/***************************************************************************
 *   Copyright (C) 2001-2004 AVM GmbH. All rights reserved.                *
 *   Copyright (C) 1998-2000 Markus Dahlweid                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kimoninfostatus.h"
#include "kimoninfostatus.moc"

#include <stdio.h>
#include <stdlib.h>

#include "../img/led_grey.xpm"
#include "../img/led_green.xpm"


/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
KIsdnInfoLineStatus::KIsdnInfoLineStatus (QWidget* parent)
                   : KLed (KLed::darkGray, KLed::On, KLed::Raised, KLed::Circular, parent),
                     m_ppixmapOff (NULL),
                     m_ppixmapGreen (NULL)
{
}

KIsdnInfoLineStatus::~KIsdnInfoLineStatus ()
{
    if ( m_ppixmapOff != NULL ) delete m_ppixmapOff;
    if ( m_ppixmapGreen != NULL ) delete m_ppixmapGreen;
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
void KIsdnInfoLineStatus::mousePressEvent (QMouseEvent* e)
{
    setLook (KLed::Sunken);
    KLed::mousePressEvent (e);
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
void KIsdnInfoLineStatus::mouseReleaseEvent (QMouseEvent* e)
{
    setLook (KLed::Raised);
    KLed::mouseReleaseEvent (e);
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
void KIsdnInfoLineStatus::paintRound ()
{
    bool bDone = false;
    if ( color () == darkGray )
    {
        if ( m_ppixmapOff == NULL ) m_ppixmapOff = new QPixmap (led_grey_xpm);
        bDone = paintXpm (m_ppixmapOff);
    }
    else if ( color () == green )
    {
        if ( m_ppixmapGreen == NULL ) m_ppixmapGreen = new QPixmap (led_green_xpm);
        bDone = paintXpm (m_ppixmapGreen);
    }
    if ( !bDone ) KLed::paintRound ();
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
bool KIsdnInfoLineStatus::paintXpm (QPixmap* ppixmap)
{
    if ( (ppixmap != NULL) && !ppixmap->isNull () )
    {
        bitBlt (this, 0, 0, ppixmap, 0, 0, ppixmap->width (), ppixmap->height (), Qt::CopyROP, false);
        return true;
    }
    
    return false;
}
