/***************************************************************************
 *   Copyright (C) 2001-2005 AVM GmbH. All rights reserved.                *
 *   Copyright (C) 1998-2000 Markus Dahlweid                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KIsdnInfoLine_H_
#define _KIsdnInfoLine_H_

#include <qwidget.h>
#include <qlabel.h>
#include <qdatetm.h>

#include "kimoninfostatus.h"

class KIsdnInfoLine : public QWidget
{
    Q_OBJECT
public:
    KIsdnInfoLine (QWidget* parent = 0, bool panel = true, const char* name = 0);
    ~KIsdnInfoLine ();

    QString GetInfoTip () const;

public:
    void set_controller (int iController);
    void set_channel (int iChannel);
    void set_online (int dir, bool bFirst);
    void set_time (QString strTime);
    void reset_time ();
    void recalc_time ();

protected:
    enum ELogEvent { log_onstart, log_ondisc, log_onexit };

    QLabel*			m_pLabelController;
    QLabel*			m_pLabelChannel;
    QLabel*			m_pLabelStatus;
    QLabel*			m_pLabelTime;
    QDateTime			_upsince;
    KIsdnInfoLineStatus*        m_pLed;
    int				_onl;
    bool			_panel;
    QWidget*                    m_pWidgetLed;
    static bool                 m_bShowLogfileError;

    // layout
    static int         m_iX;
    static int         m_iControllerCX;
    static int         m_iChannelCX;
    static int         m_iStatusCX;
    static int         m_iTimeCX;
    static const int   m_iLedCX;
    static const int   m_iSpaceCX;
    static const int   m_iY;
    static int         m_iCY;
    static const int   m_iLedCY;

    virtual void showEvent (QShowEvent*);
    virtual void styleChange (QStyle& style);
    virtual void destroy (bool destroyWindow = true, bool destroySubWindows = true);

    void UpdateLayout ();
    void Log (ELogEvent LogEvent);
};

#endif
