/***************************************************************************
 *   Copyright (C) 2001-2005 AVM GmbH. All rights reserved.                *
 *   Copyright (C) 1998-2000 Markus Dahlweid                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kimon.h"
#include "kimoninfo.h"
#include "kimoninfo.moc"
#include "ccapiinfo.h"

extern QObject *IMon;

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
KIsdnInfo::KIsdnInfo (CCapiInfo& CapiInfo, QWidget* parent, const char* name)
				 : QWidget (parent, name),
                   m_bFirstUpdate (true)
{
   	setIcon (pApp->icon ());

	// header
    KIsdnInfoLine* iil = new KIsdnInfoLine (this, false);
    iil->show ();

    // channels
    m_InfoLines.setAutoDelete (true);
    Update (CapiInfo);
}

KIsdnInfo::~KIsdnInfo ()
{
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
void KIsdnInfo::Update (CCapiInfo& CapiInfo)
{
    // all controllers
    KIsdnInfoLine* pInfoLine = NULL;
    unsigned int nLine = 0;
    bool bAllValid = true, bFoundController = false;
    for (_cbyte byController = 1; byController <= CapiInfo.ControllerCount (); byController++)
    {
		CCapiController* pController = CapiInfo.GetController (byController);
		if ( pController == NULL ) continue;		// kein Controller
				
    	// don't show DSL controller
 		if ( ((pController->GetB1 () & CAPI_B1PROTOCOL_ATM) != 0) &&
 			 ((pController->GetB2 () & CAPI_B2PROTOCOL_PPPOE) != 0) &&
 			 ((pController->GetB3 () & CAPI_B3PROTOCOL_PPPOE) != 0) )
        	continue;

        bFoundController = true;
		// update all B channels
    	for (_cbyte byChannel = 0; byChannel < pController->GetChannelCount (); byChannel++)
    	{
    		if ( nLine >= m_InfoLines.count () )
    		{
    			// new line
      			pInfoLine = new KIsdnInfoLine (this);
      			m_InfoLines.append (pInfoLine);
      		}
      		else pInfoLine = m_InfoLines.at (nLine);
      			
      		// update
      		pInfoLine->set_controller (byController);
    		pInfoLine->set_channel (byChannel + 1);
    		pInfoLine->set_online (pController->GetChannelInfo (byChannel), m_bFirstUpdate);
      		pInfoLine->move (0, (nLine + 1) * pInfoLine->height ());
      		pInfoLine->show ();
      			
      		nLine++;
    	} // for byChannel
        bAllValid = (bAllValid && pController->GotValidResponse ());
    } // for byController
    if ( bFoundController && bAllValid ) m_bFirstUpdate = false;
    		
    // remove unused lines
    while ( (nLine + 1) < m_InfoLines.count () )
    {
    	pInfoLine = m_InfoLines.getLast ();
    	if ( pInfoLine != NULL )
    	{
    		if ( pInfoLine->close (false) )
    		{
    			if ( m_InfoLines.removeLast () ) continue;
    		}
    	}
    				
    	break; // error
    } // while

    // size of the box
    pInfoLine = m_InfoLines.getFirst (); // NULL if empty
    if ( pInfoLine != NULL )
  		setFixedSize (pInfoLine->width (), (m_InfoLines.count () + 1) * pInfoLine->height () + 5);
    else
    	setFixedSize (0,0);
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
QString KIsdnInfo::GetInfoTip ()
{
    QString strInfo;
    
    KIsdnInfoLine* pInfoLine = NULL;
    for (pInfoLine = m_InfoLines.first (); pInfoLine != NULL; pInfoLine = m_InfoLines.next () )
    {
        QString str = pInfoLine->GetInfoTip ();
        if ( !str.isEmpty () )
        {
            if ( !strInfo.isEmpty () ) strInfo += '\n';
            strInfo += str;
        }
    }

    return strInfo;
}
