/***************************************************************************
 *   Copyright (C) 2001-2005 AVM GmbH. All rights reserved.                *
 *   Copyright (C) 1998-2000 Markus Dahlweid                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _IsdnMon_H_
#define _IsdnMon_H_

#include <sys/time.h>
#include <stdio.h>

#include <qwidget.h>
#include <qevent.h>
#include <qbrush.h>
#include <qstring.h>
#include <kuniqueapp.h>
#include <kpopupmenu.h>

#include "kimoninfo.h"
#include "kimonprefs.h"
#include "ccapiinfo.h"

class KIsdnMon : public QWidget
{
    Q_OBJECT
public:
    KIsdnMon (QWidget* parent = 0, const char* name = 0, WFlags f = 0);
    ~KIsdnMon ();

    void SetToolTip (QString strToolTip = QString ());
    void SetSystemTrayWindow ();

public slots:
    void open (bool bNoTimeout = false);
    void open_notimeout () { open (true); }
    void close ();
    void quit ();
    void prefs ();
    void apply ();
    void profiles ();

protected:
    int			tid;
    QBrush		brush[4];
    KIsdnInfo*	        m_pIInfo;
    bool		retry;
    CCapiInfo		m_CapiInfo;
    int 		i, lines;
    KPopupMenu*	        m_pMenu;
    int			m_iOpenOnChange;
    int			autohideTimeout, autohideTimer;
    bool		closed, enableTimeout;

    void parseConfig ();
    virtual void mousePressEvent (QMouseEvent*);
    virtual void timerEvent (QTimerEvent*);
    virtual void paintEvent (QPaintEvent*);

    void readInfo ();
};

extern const char* AppTitle;
extern const char* ErrTitle;

class KIsdnMonApplication : public KUniqueApplication
{
    Q_OBJECT
k_dcop:
    bool exit ()
    {
        quit ();
	return true;
    }
};

extern KIsdnMonApplication* pApp;

#endif // _IsdnMon_H_
