/***************************************************************************
 *   Copyright (C) 2001-2002 AVM GmbH. All rights reserved.                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontrollerprofile.h"
#include "kcontrollerprofile.moc"

#include <qstring.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlistview.h>
#include <klocale.h>


/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
KControllerProfile::KControllerProfile (CCapiController* pController, QWidget* parent)
									: QWidget (parent, NULL)
{
		clearWFlags (WStyle_ContextHelp);

    QGridLayout* pGrid = new QGridLayout (this, 6, 2, 10);
    pGrid->setRowStretch (6, 1);

		// controller info
    QLabel* pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 1, 0);
    pLabel->setText (i18n ("Manufacturer:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 1, 1);
    pLabel->setText (pController->GetManufacturer ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 2, 0);
    pLabel->setText (i18n ("CAPI-Version:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 2, 1);
    pLabel->setText (pController->GetVersion ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 3, 0);
    pLabel->setText(i18n ("Manufacturer Version:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 3, 1);
    pLabel->setText (pController->GetManufacturerVersion ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 4, 0);
    pLabel->setText(i18n ("Serial Number:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 4, 1);
    pLabel->setText (pController->GetSerialNumber ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    // tree view with controller capabilities
    QListView* pListView = new QListView (this);
    pGrid->addMultiCellWidget (pListView, 6, 6, 0, 1);
    pListView->addColumn (i18n ("Implemented Capabilities"));
    pListView->setRootIsDecorated (true);
    pListView->setSorting (-1);

    // B channel count
    QListViewItem* pToplevelItem = new QListViewItem (pListView);
    pToplevelItem->setText (0, i18n ("1 B channel", "%n B channels", (unsigned long)(pController->GetChannelCount ())));

    // controller's global options
    for (int ii = 0; ii < 32; ii++)
    {
        if ( (pController->GetOptions () & (1 << ii)) != 0 )
        {
            QString strText = STR_GlobalOptions[ii];
            if ( strText.isEmpty () )
            {
                strText.sprintf ("[%d] ", ii);
                strText.append (i18n (STR_UNKNOWN));
            }
            pToplevelItem = new QListViewItem (pListView, pToplevelItem);
            pToplevelItem->setText (0, strText);
        }
    } // for ii
  	
    // controller's b1
    pToplevelItem = new QListViewItem (pListView, pToplevelItem);
    pToplevelItem->setText (0, i18n ("B1 protocols support"));
    QListViewItem* pItem = NULL;
    for (int ii = 0; ii < 32; ii++)
    {
        if ( (pController->GetB1 () & (1 << ii)) != 0 )
        {
            QString strText = STR_B1Protocols[ii];
            if ( strText.isEmpty () )
            {
                strText.sprintf ("[%d] ", ii);
                strText.append (i18n (STR_UNKNOWN));
            }
            pItem = (pItem == NULL) ? new QListViewItem (pToplevelItem) : new QListViewItem (pToplevelItem, pItem);
            pItem->setText (0, strText);
        }
    } // for ii

    // controller's b2
    pToplevelItem = new QListViewItem (pListView, pToplevelItem);
    pToplevelItem->setText (0, i18n ("B2 protocols support"));
    pItem = NULL;
    for (int ii = 0; ii < 32; ii++)
    {
        if ( (pController->GetB2 () & (1 << ii)) != 0 )
        {
            QString strText = STR_B2Protocols[ii];
            if ( strText.isEmpty () )
            {
                strText.sprintf ("[%d] ", ii);
                strText.append (i18n (STR_UNKNOWN));
            }
            pItem = (pItem == NULL) ? new QListViewItem (pToplevelItem) : new QListViewItem (pToplevelItem, pItem);
            pItem->setText (0, strText);
        }
    } // for ii

    // controller's b3
    pToplevelItem = new QListViewItem (pListView, pToplevelItem);
    pToplevelItem->setText (0, i18n ("B3 protocols support"));
    pItem = NULL;
    for (int ii = 0; ii < 32; ii++)
    {
        if ( (pController->GetB3 () & (1 << ii)) != 0 )
        {
            QString strText = STR_B3Protocols[ii];
            if ( strText.isEmpty () )
            {
                strText.sprintf ("[%d] ", ii);
                strText.append (i18n (STR_UNKNOWN));
            }
            pItem = (pItem == NULL) ? new QListViewItem (pToplevelItem) : new QListViewItem (pToplevelItem, pItem);
            pItem->setText (0, strText);
        }
    } // for ii

    // controller's manufacturer specific profile information
    // subject to change!!
    if ( (pController->GetDProtocol () != 0) || (pController->GetLine () != 0) )
    {
        pToplevelItem = new QListViewItem (pListView, pToplevelItem);
        pToplevelItem->setText (0, i18n ("Manufacturer specific information"));
        QListViewItem* pItem = NULL;
    		
        QString strLabel (i18n ("D channel protocol: "));
        for (int ii = 0; ii < 16; ii++)
        {
            if ( (pController->GetDProtocol () & 1 << ii) != 0 )
            {
                QString strText;
                if ( STR_DChannelProtocols[ii] == NULL )
                {
                    strText.sprintf ("[%d] ", ii);
                    strText.append (i18n (STR_UNKNOWN));
                }
                else strText = STR_DChannelProtocols[ii];
                pItem = (pItem == NULL) ? new QListViewItem (pToplevelItem) : new QListViewItem (pToplevelItem, pItem);
                pItem->setText (0, strText.prepend (strLabel));
            } // if GetDPRotocol
        } // for ii
  			
    	strLabel = i18n ("Type of line: ");
        for (int ii = 0; ii < 8; ii++)
        {
            if ( (pController->GetLine () & 1 << ii) != 0 )
            {
                QString strText;
                if ( STR_Line[ii] == NULL )
                {
                    strText.sprintf ("[%d] ", ii);
                    strText.append (i18n (STR_UNKNOWN));
                }
                else strText = STR_Line[ii];
                pItem = (pItem == NULL) ? new QListViewItem (pToplevelItem) : new QListViewItem (pToplevelItem, pItem);
                pItem->setText (0, strText.prepend (strLabel));
            } // if GetLine
        } // for ii
    } // if manufacturer sepcific
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
const char* KControllerProfile::STR_GlobalOptions[32] =
{
    "Internal controller",
    "External equipment",
    "Handset",
    "DTMF",
    "Supplementary services",
    "Channel allocation",
    "Parameter B channel operation",
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const char* KControllerProfile::STR_B1Protocols[32] =
{
    "64 kBit/s with HDLC framing",
    "64 kBit/s bittransparent with byte framing from the network",
    "V.110 asynchronous operation with start/stop byte framing",
    "V.110 synchronous operation with HDLC framing",
    "T.30 modem for group 3 fax",
    "64 kBit/s inverted with HDLC framing",
    "56 kBit/s bittransparent with byte framing from the network",
    "Modem with full negotiation",
    "Modem asynchronous operation with start/stop byte framing",
    "Modem synchronous operation with HDLC framing",
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const char* KControllerProfile::STR_B2Protocols[32] =
{
    "ISO 7776 (X.75 SLP)",
    "Transparent",
    "SDLC",
    "LAPD in accordance with Q.931 for D channel X.25 (SAPI 16)",
    "T.30 for group 3 fax",
    "Point-to-point protocol (PPP)",
    "Transparent (ignoring framing errors of B1 protocol)",
    "Modem with full negotiation (e.g. V.42bis, MNP5)",
    "ISO 7776 (X.75 SLP) modified to support V.42bis compression",
    "V.120 asynchronous mode",
    "V.120 asynchronous mode with V.42bis compression",
    "V.120 bittransparent mode",
    "LAPD in accordance with Q.921 including free SAPI selection",
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const char* KControllerProfile::STR_B3Protocols[32] =
{
    "Transparent",
    "T.90NL with compatibility to T.70NL in accordance with T.90 Appendix II",
    "ISO 8208 (X.25 DTE-DTE)",
    "X.25 DCE",
    "T.30 for group 3 fax",
    "T.30 for group 3 fax extended",
    "reserved",
    "Modem",
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

const char* KControllerProfile::STR_DChannelProtocols[16] =
{
    "DSS1",
    "CT1",
    "VN3",
    "NI1",
    "AUSTEL",
    "ESS",
    "MAX",
    "1TR6",
    0,0,0,0,0,0,0,0
};

const char* KControllerProfile::STR_Line[8] =
{
    "Point to point",
    "Point to multipoint",
    "Fixed, no D channel",
    "Fixed, with D channel",
    0,0,0,0
};

const char* KControllerProfile::STR_UNKNOWN = I18N_NOOP ("Unknown");
