/***************************************************************************
 *   Copyright (C) 2004 AVM GmbH. All rights reserved.                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NETDEVSTATISTICS_H
#define NETDEVSTATISTICS_H

#include <qstring.h>

class CNetdevStatistics
{
public:
    CNetdevStatistics ();
    virtual ~CNetdevStatistics ();

    virtual bool Update ();
    unsigned int GetRxBytes () const { return m_nRxBytes; }
    unsigned int GetTxBytes () const { return m_nTxBytes; }
    
protected:
    int             m_iDevicenameSys;
    bool            m_bUseProc;
    unsigned int    m_nRxBytes;
    unsigned int    m_nTxBytes;
    
    virtual bool UpdateFromProc ();
    
    virtual bool UpdateFromSys ();
    bool GetNumFromSys (const char* pszName, unsigned int& nNum);
};


#endif // NETDEVSTATISTICS_H
