/***************************************************************************
 *   Copyright (C) 2001-2002 AVM GmbH. All rights reserved.                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MSG_H
#define MSG_H

#undef __NO_CAPIUTILS__
#include <capi20.h>


/*----- CAPI protocol functions from AVM's CAPI 2.0 development kit -----*/
/*----- if the symbol CPROT is defined, protocol functions are included -----*/

#if defined (CPROT)
enum CAPI_PROTOCOL_TYP {
    CAPI_PROTOCOL_HEADER,   /*----- occurs only once when CAPI_PROTOCOL_INIT is executed -----*/
    CAPI_PROTOCOL_MSG,	    /*----- the protocol-output is a CAPI Message -----*/
    CAPI_PROTOCOL_TXT,	    /*----- the output is text caused by CAPI_PROTOCOL_TEXT -----*/
};

#define CAPI_PROTOCOL_INIT_BUF_SIZE  (9*1024)

/*--------------------------------------------------------------------------*\
    CAPI_PROTOCOL_INIT wants as first parameter a buffer with the size
    CAPI_PROTOCOL_INIT_BUF_SIZE. The second parameter is the address of
    a callback function with 3 parameter which is called whenever there is
    protocoltext to give out. The callback functions parameter are a pointer
    to the message, the type of the message and a pointer to the CAPI Message
    if the type is CAPI_PROTOCOL_MSG.
\*--------------------------------------------------------------------------*/
void CAPI_PROTOCOL_INIT (char *_buf, void (*_signal)(char *, CAPI_PROTOCOL_TYP, CAPI_MESSAGE));

/*--------------------------------------------------------------------------*\
    CAPI_PROTOCOL_MESSAGE prints the specified CAPI message on the protocol
\*--------------------------------------------------------------------------*/
void CAPI_PROTOCOL_MESSAGE (CAPI_MESSAGE msg);

/*--------------------------------------------------------------------------*\
    CAPI_PROTOCOL_TEXT prints the specified text on the protocol.
    It has the same syntax as printf
\*--------------------------------------------------------------------------*/
void CAPI_PROTOCOL_TEXT (char *fmt, ...);
#endif // CPROT


#endif // MSG_H
