/***************************************************************************
 *   Copyright (C) 2001-2002 AVM GmbH. All rights reserved.                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "msg.h"

#if defined (CPROT)
#include "config.h"
#include <stdio.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>

typedef struct {
    int typ;
    unsigned off;
} _cdef;

#define _CBYTE         1
#define _CWORD         2
#define _CDWORD        3
#define _CSTRUCT       4
#define _CMSTRUCT      5
#define _CEND          6

/*-------------------------------------------------------*/
static _cdef cdef[] = {
    /*00*/{_CEND, 0},
    /*01*/{_CEND, 0},
    /*02*/{_CEND, 0},
    /*03*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->adr.adrController},
    /*04*/{_CMSTRUCT, (unsigned)(unsigned long)&((_cmsg *)0)->AdditionalInfo},
    /*05*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->B1configuration},
    /*06*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->B1protocol},
    /*07*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->B2configuration},
    /*08*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->B2protocol},
    /*09*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->B3configuration},
    /*0a*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->B3protocol},
    /*0b*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->BC},
    /*0c*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->BChannelinformation},
    /*0d*/{_CMSTRUCT, (unsigned)(unsigned long)&((_cmsg *)0)->BProtocol},
    /*0e*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->CalledPartyNumber},
    /*0f*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->CalledPartySubaddress},
    /*10*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->CallingPartyNumber},
    /*11*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->CallingPartySubaddress},
    /*12*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->CIPmask},
    /*13*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->CIPmask2},
    /*14*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->CIPValue},
    /*15*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->Class},
    /*16*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->ConnectedNumber},
    /*17*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->ConnectedSubaddress},
    /*18*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->Data},
    /*19*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->DataHandle},
    /*1a*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->DataLength},
    /*1b*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->FacilityConfirmationParameter},
    /*1c*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->Facilitydataarray},
    /*1d*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->FacilityIndicationParameter},
    /*1e*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->FacilityRequestParameter},
    /*1f*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->FacilitySelector},
    /*20*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->Flags},
    /*21*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->Function},
    /*22*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->HLC},
    /*23*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->Info},
    /*24*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->InfoElement},
    /*25*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->InfoMask},
    /*26*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->InfoNumber},
    /*27*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->Keypadfacility},
    /*28*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->LLC},
    /*29*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->ManuData},
    /*2a*/{_CDWORD,   (unsigned)(unsigned long)&((_cmsg *)0)->ManuID},
    /*2b*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->NCPI},
    /*2c*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->Reason},
    /*2d*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->Reason_B3},
    /*2e*/{_CWORD,    (unsigned)(unsigned long)&((_cmsg *)0)->Reject},
    /*2f*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->Useruserdata},
    /*30*/{_CSTRUCT,  (unsigned)(unsigned long)&((_cmsg *)0)->FacilityResponseParameters},
};

/*-------------------------------------------------------*/
static unsigned char * cpars[] = {
    /*00*/ 0,
    /*01 ALERT_REQ*/        (unsigned char*)"\x03\x04\x0c\x27\x2f\x1c\x01\x01",
    /*02 CONNECT_REQ*/        (unsigned char*)"\x03\x14\x0e\x10\x0f\x11\x0d\x06\x08\x0a\x05\x07\x09\x01\x0b\x28\x22\x04\x0c\x27\x2f\x1c\x01\x01",
    /*03*/ 0,
    /*04 DISCONNECT_REQ*/     (unsigned char*)"\x03\x04\x0c\x27\x2f\x1c\x01\x01",
    /*05 LISTEN_REQ*/       (unsigned char*)"\x03\x25\x12\x13\x10\x11\x01",
    /*06*/ 0,
    /*07*/ 0,
    /*08 INFO_REQ*/       (unsigned char*)"\x03\x0e\x04\x0c\x27\x2f\x1c\x01\x01",
    /*09 FACILITY_REQ*/       (unsigned char*)"\x03\x1f\x1e\x01",
    /*0a SELECT_B_PROTOCOL_REQ*/ (unsigned char*)"\x03\x0d\x06\x08\x0a\x05\x07\x09\x01\x01",
    /*0b CONNECT_B3_REQ*/     (unsigned char*)"\x03\x2b\x01",
    /*0c*/ 0,
    /*0d DISCONNECT_B3_REQ*/  (unsigned char*)"\x03\x2b\x01",
    /*0e*/ 0,
    /*0f DATA_B3_REQ*/        (unsigned char*)"\x03\x18\x1a\x19\x20\x01",
    /*10 RESET_B3_REQ*/       (unsigned char*)"\x03\x2b\x01",
    /*11*/ 0,
    /*12*/ 0,
    /*13 ALERT_CONF*/       (unsigned char*)"\x03\x23\x01",
    /*14 CONNECT_CONF*/       (unsigned char*)"\x03\x23\x01",
    /*15*/ 0,
    /*16 DISCONNECT_CONF*/    (unsigned char*)"\x03\x23\x01",
    /*17 LISTEN_CONF*/        (unsigned char*)"\x03\x23\x01",
    /*18 MANUFACTURER_REQ*/   (unsigned char*)"\x03\x2a\x15\x21\x29\x01",
    /*19*/ 0,
    /*1a INFO_CONF*/        (unsigned char*)"\x03\x23\x01",
    /*1b FACILITY_CONF*/      (unsigned char*)"\x03\x23\x1f\x1b\x01",
    /*1c SELECT_B_PROTOCOL_CONF*/ (unsigned char*)"\x03\x23\x01",
    /*1d CONNECT_B3_CONF*/    (unsigned char*)"\x03\x23\x01",
    /*1e*/ 0,
    /*1f DISCONNECT_B3_CONF*/ (unsigned char*)"\x03\x23\x01",
    /*20*/ 0,
    /*21 DATA_B3_CONF*/       (unsigned char*)"\x03\x19\x23\x01",
    /*22 RESET_B3_CONF*/      (unsigned char*)"\x03\x23\x01",
    /*23*/ 0,
    /*24*/ 0,
    /*25*/ 0,
    /*26 CONNECT_IND*/        (unsigned char*)"\x03\x14\x0e\x10\x0f\x11\x0b\x28\x22\x04\x0c\x27\x2f\x1c\x01\x01",
    /*27 CONNECT_ACTIVE_IND*/ (unsigned char*)"\x03\x16\x17\x28\x01",
    /*28 DISCONNECT_IND*/     (unsigned char*)"\x03\x2c\x01",
    /*29*/ 0,
    /*2a MANUFACTURER_CONF*/  (unsigned char*)"\x03\x2a\x15\x21\x29\x01",
    /*2b*/ 0,
    /*2c INFO_IND*/       (unsigned char*)"\x03\x26\x24\x01",
    /*2d FACILITY_IND*/       (unsigned char*)"\x03\x1f\x1d\x01",
    /*2e*/ 0,
    /*2f CONNECT_B3_IND*/     (unsigned char*)"\x03\x2b\x01",
    /*30 CONNECT_B3_ACTIVE_IND*/ (unsigned char*)"\x03\x2b\x01",
    /*31 DISCONNECT_B3_IND*/  (unsigned char*)"\x03\x2d\x2b\x01",
    /*32*/ 0,
    /*33 DATA_B3_IND*/        (unsigned char*)"\x03\x18\x1a\x19\x20\x01",
    /*34 RESET_B3_IND*/       (unsigned char*)"\x03\x2b\x01",
    /*35 CONNECT_B3_T90_ACTIVE_IND*/ (unsigned char*)"\x03\x2b\x01",
    /*36*/ 0,
    /*37*/ 0,
    /*38 CONNECT_RESP*/       (unsigned char*)"\x03\x2e\x0d\x06\x08\x0a\x05\x07\x09\x01\x16\x17\x28\x04\x0c\x27\x2f\x1c\x01\x01",
    /*39 CONNECT_ACTIVE_RESP*/ (unsigned char*)"\x03\x01",
    /*3a DISCONNECT_RESP*/    (unsigned char*)"\x03\x01",
    /*3b*/ 0,
    /*3c MANUFACTURER_IND*/   (unsigned char*)"\x03\x2a\x15\x21\x29\x01",
    /*3d*/ 0,
    /*3e INFO_RESP*/        (unsigned char*)"\x03\x01",
    /*3f FACILITY_RESP*/      (unsigned char*)"\x03\x1f\x30\x01",
    /*40*/ 0,
    /*41 CONNECT_B3_RESP*/    (unsigned char*)"\x03\x2e\x2b\x01",
    /*42 CONNECT_B3_ACTIVE_RESP*/ (unsigned char*)"\x03\x01",
    /*43 DISCONNECT_B3_RESP*/ (unsigned char*)"\x03\x01",
    /*44*/ 0,
    /*45 DATA_B3_RESP*/       (unsigned char*)"\x03\x19\x01",
    /*46 RESET_B3_RESP*/      (unsigned char*)"\x03\x01",
    /*47 CONNECT_B3_T90_ACTIVE_RESP*/ (unsigned char*)"\x03\x01",
    /*48*/ 0,
    /*49*/ 0,
    /*4a*/ 0,
    /*4b*/ 0,
    /*4c*/ 0,
    /*4d*/ 0,
    /*4e MANUFACTURER_RESP*/  (unsigned char*)"\x03\x2a\x15\x21\x29\x01",
};

#define byteTLcpy(x,y)        *(_cbyte *)(x)=*(_cbyte *)(y);
#define wordTLcpy(x,y)        *(_cword *)(x)=*(_cword *)(y);
#define dwordTLcpy(x,y)       memcpy(x,y,4);
#define structTLcpy(x,y,l)    memcpy (x,y,l)
#define structTLcpyovl(x,y,l) memmove (x,y,l)

#define byteTRcpy(x,y)        *(_cbyte *)(y)=*(_cbyte *)(x);
#define wordTRcpy(x,y)        *(_cword *)(y)=*(_cword *)(x);
#define dwordTRcpy(x,y)       memcpy(y,x,4);
#define structTRcpy(x,y,l)    memcpy (y,x,l)
#define structTRcpyovl(x,y,l) memmove (y,x,l)

/*-------------------------------------------------------*/
static unsigned command_2_index (unsigned c, unsigned sc) {
    if (c & 0x80) c = 0x9+(c&0x0f);
    else if (c<=0x0f) ;
    else if (c==0x41) c = 0x9+0x1;
    else if (c==0xff) c = 0x00;
    return (sc&3)*(0x9+0x9)+c;
}

/*-------------------------------------------------------*/
#define TYP (cdef[cmsg->par[cmsg->p]].typ)
#define OFF (((char *)cmsg)+cdef[cmsg->par[cmsg->p]].off)

static void jumpcstruct (_cmsg *cmsg) {
    unsigned layer;

    layer=1;
    do {
        cmsg->p++;
        switch (TYP) {
        case _CMSTRUCT:
            layer++;
            break;
        case _CEND:
            layer--;
            break;
        }
    } while (layer > 0);
}

/*-------------------------------------------------------*/
static char * pnames[] = {
    /*00*/0,
    /*01*/0,
    /*02*/0,
    /*03*/"Controller/PLCI/NCCI",
    /*04*/"AdditionalInfo",
    /*05*/"B1configuration",
    /*06*/"B1protocol",
    /*07*/"B2configuration",
    /*08*/"B2protocol",
    /*09*/"B3configuration",
    /*0a*/"B3protocol",
    /*0b*/"BC",
    /*0c*/"BChannelinformation",
    /*0d*/"BProtocol",
    /*0e*/"CalledPartyNumber",
    /*0f*/"CalledPartySubaddress",
    /*10*/"CallingPartyNumber",
    /*11*/"CallingPartySubaddress",
    /*12*/"CIPmask",
    /*13*/"CIPmask2",
    /*14*/"CIPValue",
    /*15*/"Class",
    /*16*/"ConnectedNumber",
    /*17*/"ConnectedSubaddress",
    /*18*/"Data",
    /*19*/"DataHandle",
    /*1a*/"DataLength",
    /*1b*/"FacilityConfirmationParameter",
    /*1c*/"Facilitydataarray",
    /*1d*/"FacilityIndicationParameter",
    /*1e*/"FacilityRequestParameter",
    /*1f*/"FacilitySelector",
    /*20*/"Flags",
    /*21*/"Function",
    /*22*/"HLC",
    /*23*/"Info",
    /*24*/"InfoElement",
    /*25*/"InfoMask",
    /*26*/"InfoNumber",
    /*27*/"Keypadfacility",
    /*28*/"LLC",
    /*29*/"ManuData",
    /*2a*/"ManuID",
    /*2b*/"NCPI",
    /*2c*/"Reason",
    /*2d*/"Reason_B3",
    /*2e*/"Reject",
    /*2f*/"Useruserdata",
    /*30*/"FacilityResponseParameters",
};

/*-------------------------------------------------------*/
static char * mnames[] = {
    0,
    "ALERT_REQ",
    "CONNECT_REQ",
    0,
    "DISCONNECT_REQ",
    "LISTEN_REQ",
    0,
    0,
    "INFO_REQ",
    "FACILITY_REQ",
    "SELECT_B_PROTOCOL_REQ",
    "CONNECT_B3_REQ",
    0,
    "DISCONNECT_B3_REQ",
    0,
    "DATA_B3_REQ",
    "RESET_B3_REQ",
    0,
    0,
    "ALERT_CONF",
    "CONNECT_CONF",
    0,
    "DISCONNECT_CONF",
    "LISTEN_CONF",
    "MANUFACTURER_REQ",
    0,
    "INFO_CONF",
    "FACILITY_CONF",
    "SELECT_B_PROTOCOL_CONF",
    "CONNECT_B3_CONF",
    0,
    "DISCONNECT_B3_CONF",
    0,
    "DATA_B3_CONF",
    "RESET_B3_CONF",
    0,
    0,
    0,
    "CONNECT_IND",
    "CONNECT_ACTIVE_IND",
    "DISCONNECT_IND",
    0,
    "MANUFACTURER_CONF",
    0,
    "INFO_IND",
    "FACILITY_IND",
    0,
    "CONNECT_B3_IND",
    "CONNECT_B3_ACTIVE_IND",
    "DISCONNECT_B3_IND",
    0,
    "DATA_B3_IND",
    "RESET_B3_IND",
    "CONNECT_B3_T90_ACTIVE_IND",
    0,
    0,
    "CONNECT_RESP",
    "CONNECT_ACTIVE_RESP",
    "DISCONNECT_RESP",
    0,
    "MANUFACTURER_IND",
    0,
    "INFO_RESP",
    "FACILITY_RESP",
    0,
    "CONNECT_B3_RESP",
    "CONNECT_B3_ACTIVE_RESP",
    "DISCONNECT_B3_RESP",
    0,
    "DATA_B3_RESP",
    "RESET_B3_RESP",
    "CONNECT_B3_T90_ACTIVE_RESP",
    0,
    0,
    0,
    0,
    0,
    0,
    "MANUFACTURER_RESP"
};

static void (*signal)(char *, CAPI_PROTOCOL_TYP, CAPI_MESSAGE);
static char * buf=0, * p=0;
/*-------------------------------------------------------*/
void bufprint (char *fmt, ...) {
    va_list f;
    va_start (f,fmt);
    vsprintf (p,fmt,f);
    va_end (f);
    p+=strlen(p);
}

/*-------------------------------------------------------*/
static void printstructlen (_cbyte  *m, unsigned len) {
    unsigned hex = 0;
    for (;len;len--,m++)
  if (isalnum (*m) | (*m == ' ')) {
      if (hex)
    bufprint (">");
      bufprint ("%c", *m);
      hex = 0;
  }
  else {
      if (!hex)
    bufprint ("<%02x", *m);
      else
    bufprint (" %02x", *m);
      hex = 1;
  }
    if (hex)
  bufprint (">");
}

/*-------------------------------------------------------*/
static void printstruct (_cbyte *m) {
    unsigned len;
    if (m[0] != 0xff) {
  len = m[0];
  m+=1;
    }
    else {
  len = ((_cword *)(m+1))[0];
  m+=3;
    }
    printstructlen (m, len);
}

/*-------------------------------------------------------*/
#define NAME (pnames[cmsg->par[cmsg->p]])

static void PROTOCOL_MESSAGE_2_PARS (_cmsg *cmsg, int level, _cbyte *ende) {
    for (;TYP != _CEND; cmsg->p++) {
  int slen = 29+3-level;
  int i;

    if (cmsg->m + cmsg->l >= ende) {
        jumpcstruct (cmsg);
        return;
    }

  bufprint ("  ");
  for (i=0; i<level-1; i++) bufprint (" ");

  switch (TYP) {
      case _CBYTE:
    bufprint ("%-*s = 0x%x\n", slen, NAME, *(_cbyte *)(cmsg->m+cmsg->l));
    cmsg->l++;
    break;
      case _CWORD:
    bufprint ("%-*s = 0x%x\n", slen, NAME, *(_cword *)(cmsg->m+cmsg->l));
    cmsg->l+=2;
    break;
      case _CDWORD:
    if (strcmp(NAME,"Data")==0) {
        bufprint ("%-*s = ", slen, NAME);
        printstructlen ((_cbyte *)*(_cdword *)(cmsg->m+cmsg->l),
           *(_cword *)(cmsg->m+cmsg->l+sizeof(_cdword)));
        bufprint ("\n");
    }
    else
        bufprint ("%-*s = 0x%lx\n", slen, NAME, *(_cdword *)(cmsg->m+cmsg->l));
    cmsg->l+=4;
    break;
      case _CSTRUCT:
    bufprint ("%-*s = ", slen, NAME);
    if (cmsg->m[cmsg->l]=='\0')
        bufprint ("default");
    else
        printstruct (cmsg->m+cmsg->l);
    bufprint ("\n");
    if (cmsg->m[cmsg->l] != 0xff)
        cmsg->l+= 1+ cmsg->m[cmsg->l];
    else
        cmsg->l+= 3+ *(_cword *)(cmsg->m+cmsg->l+1);

    break;

      case _CMSTRUCT:
    /*----- Metastruktur 0 -----*/
    if (cmsg->m[cmsg->l] == '\0') {
        bufprint ("%-*s = default\n", slen, NAME);
        cmsg->l++;
        jumpcstruct (cmsg);
    }
    else {
        char *name = NAME;
        unsigned len;
        unsigned next;

        bufprint ("%-*s\n", slen, name);
        if ((cmsg->m + cmsg->l)[0] == 255) {
            wordTRcpy(cmsg->m + cmsg->l + 1, &len);
            cmsg->l += 3;
        }
        else {
            len = (cmsg->m + cmsg->l)[0];
            cmsg->l++;
        }
        cmsg->p++;
        next = cmsg->l + len;
        PROTOCOL_MESSAGE_2_PARS (cmsg, level+1, cmsg->m + cmsg->l + len);
        cmsg->l = next;
	}
    break;
  }
    }
}
/*-------------------------------------------------------*/
#include <time.h>
void CAPI_PROTOCOL_INIT (char *_buf, void (*_signal)(char *, CAPI_PROTOCOL_TYP, CAPI_MESSAGE)) {
    time_t  ltime;
    char    *date;


    buf = _buf;
    signal = _signal;
    p = buf; p[0]=0;
    if (buf==NULL||signal==NULL) return;
    bufprint ("+---------------------------------------------------------------------\n");
    bufprint ("|   kadslwatch %-12s                COMMON-ISDN-API Version 2.0\n", VERSION);
    bufprint ("|\n");
    time (&ltime);
    date = ctime (&ltime);
    date[24]='\0';
    bufprint ("|%*s\n", 69/2 + strlen(date)/2, date);
    bufprint ("+---------------------------------------------------------------------\n");
    (*signal)(buf, CAPI_PROTOCOL_HEADER, NULL);
    p = buf;
    p[0]=0;
}

/*-------------------------------------------------------*/
void CAPI_PROTOCOL_TEXT (char *fmt, ...) {
    va_list f;
    if (buf==NULL||signal==NULL) return;
    p = buf; p[0]=0;
    va_start (f,fmt);
    vsprintf (p,fmt,f);
    va_end (f);
    (*signal)(p, CAPI_PROTOCOL_TXT, NULL);
}

/*-------------------------------------------------------*/
void CAPI_PROTOCOL_MESSAGE (CAPI_MESSAGE msg) {
    _cmsg   cmsg;
    _cword          len;

    p = buf;
    p[0]=0;
    if (buf==NULL || signal==NULL) return;

    wordTRcpy (msg, &len);
    cmsg.m = msg;
    cmsg.l = 8;
    cmsg.p = 0;
    byteTRcpy (msg + 4, &cmsg.Command);
    byteTRcpy (msg + 5, &cmsg.Subcommand);
    cmsg.par = cpars [command_2_index (cmsg.Command,cmsg.Subcommand)];

    bufprint ("\n%-26s ID=%03d #0x%04x LEN=%04d\n",
    					mnames[command_2_index (cmsg.Command,cmsg.Subcommand)],
    					((unsigned short *)msg)[1],
    					((unsigned short *)msg)[3],
    					((unsigned short *)msg)[0]);

    PROTOCOL_MESSAGE_2_PARS (&cmsg, 1, msg + len);
    (*signal)(buf, CAPI_PROTOCOL_MSG, msg);
}

#endif // CPROT
