/***************************************************************************
 *   Copyright (C) 2001-2002 AVM GmbH. All rights reserved.                *
 *   Copyright (C) 1998-2000 Markus Dahlweid                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kimonprefs.h"
#include "kimonprefs.moc"
#include "ccapiinfo.h"

#include <kapp.h>
#include <qlabel.h>
#include <qlayout.h>
#include <kconfig.h>
#include <klocale.h>


extern KConfig  *kimonConf;

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
KIsdnPathPrefs::KIsdnPathPrefs (QWidget* parent, const char* name)
							: QWidget (parent, name)
{
    QGridLayout* g = new QGridLayout (this, 10, 2, 10);
    g->setColStretch (1, 1 );
    g->setColStretch (0, 0 );
    g->setRowStretch (0, 0);

    OpenOnUp = new QCheckBox (this);
    OpenOnDown = new QCheckBox (this);
    autoHide = new QCheckBox (this);
    hideTimeout = new QLineEdit (this);
    beSticky = new QCheckBox (this);

    int minheight = OpenOnUp->sizeHint ().height () + 2;
    
    OpenOnUp->setMinimumSize (100,minheight);
    OpenOnDown->setMinimumSize (100,minheight);
    autoHide->setMinimumSize (100,minheight);
    hideTimeout->setMinimumSize (100,minheight);
    beSticky->setMinimumSize (100,minheight);

    g->addWidget (OpenOnUp, 1, 1);
    g->addWidget (OpenOnDown, 2, 1);
    g->addWidget (autoHide, 3, 1);
    g->addWidget (hideTimeout, 4, 1);
    g->addWidget (beSticky, 5, 1);

    QLabel* pLabel = new QLabel (this);
    g->addWidget (pLabel, 1, 0);
    pLabel->setText (i18n ("Open monitor window on &connect:"));
    pLabel->setBuddy (OpenOnUp);
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    g->addWidget (pLabel, 2, 0);
    pLabel->setText (i18n ("Open monitor window on &disconnect:"));
    pLabel->setBuddy (OpenOnDown);
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    g->addWidget (pLabel, 3, 0);
    pLabel->setText (i18n ("&Autohide window:"));
    pLabel->setBuddy (autoHide);
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    g->addWidget (pLabel, 4, 0);
    pLabel->setText (i18n ("&Timeout for autohiding:"));
    pLabel->setBuddy (hideTimeout);
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    g->addWidget (pLabel, 5, 0);
    pLabel->setText (i18n ("&Sticky status window:"));
    pLabel->setBuddy (beSticky);
    pLabel->setMinimumSize (pLabel->sizeHint ());

    g->activate ();
    readValues ();
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
KIsdnPathPrefs::~KIsdnPathPrefs()
{
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
void KIsdnPathPrefs::readValues ()
{
    int iOpenOnCall = kimonConf->readNumEntry ("OpenOnCall", CCapiInfo::line_up);
    OpenOnUp->setChecked ((iOpenOnCall & CCapiInfo::line_up) != 0);
    OpenOnDown->setChecked ((iOpenOnCall & CCapiInfo::line_down) != 0);
    autoHide->setChecked (kimonConf->readBoolEntry ("EnableAutohide", true));
    if ( 2 > kimonConf->readNumEntry ("AutohideTimeout", 30) )
        hideTimeout->setText ("2");
    else
        hideTimeout->setText (kimonConf->readEntry ("AutohideTimeout", "30"));
    beSticky->setChecked (kimonConf->readBoolEntry ("BeSticky", true));

    repaint ();
}

/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
void KIsdnPathPrefs::saveValues ()
{
    int iOpenOnCall = CCapiInfo::line_nop;
    if ( OpenOnUp->isChecked () ) iOpenOnCall |= CCapiInfo::line_up;
    if ( OpenOnDown->isChecked () ) iOpenOnCall |= CCapiInfo::line_down;
    kimonConf->writeEntry ("OpenOnCall", iOpenOnCall);
    kimonConf->writeEntry ("AutohideTimeout", hideTimeout->text ());
    kimonConf->writeEntry ("EnableAutohide", autoHide->isChecked ());
    kimonConf->writeEntry ("BeSticky", beSticky->isChecked ());
}
