/***************************************************************************
 *   Copyright (C) 2001-2005 AVM GmbH. All rights reserved.                *
 *   Copyright (C) 1998-2000 Markus Dahlweid                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KIsdnInfo_H_
#define _KIsdnInfo_H_

#include <stdio.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qstring.h>
#include <qdatetm.h>
#include <karrowbutton.h>
#include "kimoninfostatus.h"
#include "dslinfo.h"

class KIsdnInfo : public QWidget
{
    Q_OBJECT
public:
    KIsdnInfo (QWidget* parent = 0, const char* name = 0);
    ~KIsdnInfo ();

    void Update (CDslInfo& CapiInfo);
    void AboutToClose ();

    QString GetInfoTip () const;
    
protected:
    enum ELogEvent { log_onstart, log_ondisc, log_onexit, log_reset };

	QLabel*					m_pLabelStatus;
	QLabel*					m_pStatus;
	QLabel*					m_pLabelTime;
	QLabel*					m_pTime;
	QLabel*					m_pLabelAdsl;
    QWidget*                m_pWidgetAdsl;
	KIsdnInfoLineStatus*	m_pLedAdsl;
	QLabel*					m_pLabelAtm;
    QWidget*                m_pWidgetAtm;
	KIsdnInfoLineStatus*	m_pLedAtm;
	QLabel*					m_pLabelPPP;
    QWidget*                m_pWidgetPPP;
	KIsdnInfoLineStatus*	m_pLedPPP;
	QLabel*					m_pLabelFP;
    QWidget*                m_pWidgetFP;
	KIsdnInfoLineStatus*	m_pLedFP;
	QLabel*					m_pLabelRate;
	QLabel*					m_pRate;
	QLabel*					m_pLabelTransfer;
	QLabel*					m_pTransfer;
    QLabel*					m_pLabelTotalTime;
    QLabel*					m_pTotalTime;
	QPushButton*			m_pButtonReset;
    KArrowButton*                           m_pCompactButton;
    QLabel*					m_pSeparator;
	QDateTime				m_tmStartOnline;
	int				        m_OnlineResetSecs;
	bool					m_bOnline;
    bool                    m_bShowLogfileError;
    bool                    m_bFirstUpdate;

    // transfer snapshot
    unsigned int	        m_nRxBytes;
    unsigned int	        m_nTxBytes;

    // layout
    static int              m_iX;
    static int              m_iStatusCX;
    static int              m_iTimeCX;
    static int              m_iRateCX;
    static int              m_iAdslAtmPPPCX;
    static const int        m_iLedCX;
    static const int        m_iSpaceCX;
    static const int        m_iSpaceCY;
    static const int        m_iY;
    static int              m_iCY;
    static const int        m_iLedCY;
    static const int        m_iCompactCX;
    static const int        m_iCompactCY;
    static const int        m_iCompactSeparatorCY;
		
    void UpdateLayout ();
    void Log (ELogEvent LogEvent);
    virtual void destroy (bool destroyWindow = true, bool destroySubWindows = true);

public:
    virtual void showEvent (QShowEvent*);
    virtual void styleChange (QStyle& style);

protected slots:
    void SetOnline (bool bOnline);
    virtual void ResetTransfer ();
    virtual QString FormatBytes (double f);
    virtual void ToggleCompact ();
};

#endif
