/***************************************************************************
 *   Copyright (C) 2001-2002 AVM GmbH. All rights reserved.                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kcontrollerprofile.h"
#include "kcontrollerprofile.moc"
#include "dslinfo.h"

#include <qstring.h>
#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>


/*--------------------------------------------------------------------------*\
\*--------------------------------------------------------------------------*/
KControllerProfile::KControllerProfile (CCapiController* pController, CDslInfo* pDslInfo, QWidget* parent)
                  : QWidget (parent, NULL)
{
    clearWFlags (WStyle_ContextHelp);

    QGridLayout* pGrid = new QGridLayout (this, (pDslInfo != NULL) ? 7 : 4, 2, 10);

		// controller info
    QLabel* pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 1, 0);
    pLabel->setText (i18n ("Manufacturer:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 1, 1);
    pLabel->setText (pController->GetManufacturer ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 2, 0);
    pLabel->setText (i18n ("CAPI-Version:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 2, 1);
    pLabel->setText (pController->GetVersion ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 3, 0);
    pLabel->setText(i18n ("Manufacturer Version:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 3, 1);
    pLabel->setText (pController->GetManufacturerVersion ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 4, 0);
    pLabel->setText(i18n ("Serial Number:"));
    pLabel->setMinimumSize (pLabel->sizeHint ());
    pLabel = new QLabel (this);
    pGrid->addWidget (pLabel, 4, 1);
    pLabel->setText (pController->GetSerialNumber ());
    pLabel->setMinimumSize (pLabel->sizeHint ());

    // DSL-Info
    if ( pDslInfo != NULL )
    {
        pLabel = new QLabel (this);
        pGrid->addWidget (pLabel, 5, 0);
        pLabel->setText(i18n ("DSL-Bin:"));
        pLabel->setMinimumSize (pLabel->sizeHint ());
        pLabel = new QLabel (this);
        pGrid->addWidget (pLabel, 5, 1);
        pLabel->setText (pDslInfo->GetDslBinVersion ());
        pLabel->setMinimumSize (pLabel->sizeHint ());

        pLabel = new QLabel (this);
        pGrid->addWidget (pLabel, 6, 0);
        pLabel->setText(i18n ("Remote Vendor:"));
        pLabel->setMinimumSize (pLabel->sizeHint ());
        pLabel = new QLabel (this);
        pGrid->addWidget (pLabel, 6, 1);
        pLabel->setText (pDslInfo->GetRemoteVendor ());
        pLabel->setMinimumSize (pLabel->sizeHint ());

        pLabel = new QLabel (this);
        pGrid->addWidget (pLabel, 7, 0);
        pLabel->setText(i18n ("Remote Version:"));
        pLabel->setMinimumSize (pLabel->sizeHint ());
        pLabel = new QLabel (this);
        pGrid->addWidget (pLabel, 7, 1);
        pLabel->setText (pDslInfo->GetRemoteVersion ());
        pLabel->setMinimumSize (pLabel->sizeHint ());
    }
}
