/***************************************************************************
 *   Copyright (C) 2001-2004 AVM GmbH. All rights reserved.                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DSLINFO_H
#define DSLINFO_H

#include <ccapiinfo.h>
#include <qdatetm.h>
#include "netdevstatistics.h"


#define CAPI_MANUFUNCTION_ATM			5
#define CAPI_MANUFUNCTION_ADSLLM		7
#define CAPI_MANUFUNCTION_LEDS          11
#define CapiNoDslcontroller				0xFFFF


class CIdent
{
public:
    _cword		m_wStd;
    unsigned char	m_RVI[8];
    unsigned char	m_RVN[2];
    unsigned char	m_LVI[8];
    unsigned char	m_LVN[4];

    CIdent ();
    _cword Set (unsigned char* pLmIdent = NULL); // NULL to reset members
};


class CDslInfo : public CCapiInfo
{
public:
    enum EDslStatus { offline = 0, adsl_start, adsl_unplugged, adsl_train, adsl_retrain, adsl_online, atm_online, ppp_online };

    CDslInfo ();
    virtual ~CDslInfo ();

    virtual unsigned int GetLastError () const { return CCapiInfo::GetLastError (); } // "using" didn't do it!
    virtual unsigned int GetLastError (QString& strMsg) const;
		
    virtual bool Register(QString& strMsg);
    virtual bool Release ();
    virtual CCapiController* GetDslController ();
    virtual EDslStatus GetStatus () const;
    static QString GetStatusString (EDslStatus DslStatus);
    bool GotValidResponse () const { return m_bValidResponse; }

    virtual bool ReadProfile ();
    virtual bool Update();
  	
    virtual unsigned long GetRxBytes () const { return m_nRxBytes; }
    virtual double GetRxRate () const { return m_fRxRate; }
    virtual unsigned long GetTxBytes () const { return m_nTxBytes; }
    virtual double GetTxRate () const { return m_fTxRate; }
  	
    QString GetDslBinVersion () const;
    QString GetRemoteVendor () const;
    QString GetRemoteVersion () const;

    bool IsFastPath () const { return m_bFastPath; }
    void SetInfoLED (bool bOn = false);
		
protected:
    _cbyte               m_byDslController;
    EDslStatus           m_Status;
    CIdent               m_Ident;
    bool                 m_bValidResponse;
    bool                 m_bFastPath;
		
    // snapshot
    QTime                m_tmSnapshot;
    unsigned int         m_nRxBytes;
    double               m_fRxRate;
    unsigned int         m_nTxBytes;
    double               m_fTxRate;
    CNetdevStatistics    m_NetdevStatistics;

    // use seperate buffer for CAPI_MANUFUNCTION_ATM
    _cstruct			m_pManuAtmData;
    bool                m_bManuAtmPending;

    virtual _cword ManufacturerRequest (_cbyte byController, _cdword dwFunction);
  	
    virtual unsigned int GetManuDataSize () const { return 1024; }
    virtual _cword PutRequestMessages ();
    virtual _cword GetAndProcessMessage ();
    virtual void ProcessAtm (_cstruct pManuData);
    virtual void ProcessAdslLm (_cstruct pManuData);
  	
    QString GetFromVendorTable (_cdword dwRVI) const;
};

inline CCapiController* CDslInfo::GetDslController ()
{
		return ( IsInit() && (m_byDslController > 0) ) ? GetController (m_byDslController) : NULL;
}

inline CDslInfo::EDslStatus CDslInfo::GetStatus () const
{
		return ( IsInit() && (m_byDslController > 0) ) ? m_Status : offline;
}


#endif // DSLINFO_H
