/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.soap.ISoapCredentials;

public class SetSecurityKeys extends WLANSoapHelper<Boolean>
{
	private String mKeyPassphrase;
	
	/**
	 * Sets the WLAN KeyPassphrase
	 * 
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 * @param KeyPassphrase
	 * 		The new passphrase for WPA/2
	 * @throws IllegalArgumentException
	 * 		illegal value of a member of mode 
	 * 
	 * NewWEPKey0-3 and NewPreSharedKey are transmitted empty.
	 * 
	 */
	public SetSecurityKeys(ISoapCredentials soapCredentials, int interfaceIndex,
			String KeyPassphrase)
	{
		super(soapCredentials, interfaceIndex);
		
		mKeyPassphrase = KeyPassphrase;
	}

	@Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		// no out parameter, check for error response
		exceptOnFault(getSoapBody());
		return Boolean.TRUE;
	}

	@Override
	protected String filterSoapBeforeTrace(String body)
	{
        return replaceSecrets(body, new String[]
                {
                    "NewKeyPassphrase"
// unused
//                    ,"NewPreSharedKey"
//                    ,"NewWEPKey0"
//                    ,"NewWEPKey1"
//                    ,"NewWEPKey2"
//                    ,"NewWEPKey3"
                });
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewKeyPassphrase>" + encodeEntities(mKeyPassphrase) + "</NewKeyPassphrase>"
				
				+"<NewPreSharedKey></NewPreSharedKey>"	// unused
				+"<NewWEPKey0></NewWEPKey0>"
				+"<NewWEPKey1></NewWEPKey1>"
				+"<NewWEPKey2></NewWEPKey2>"
				+"<NewWEPKey3></NewWEPKey3>"
				;
	}

	@Override
	public String getSoapMethod()
	{
		return "SetSecurityKeys";
	}
}
