/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.StringSpec;
import de.avm.android.tr064.model.WLANConfigInfo;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetInfo extends WLANSoapHelper<WLANConfigInfo>
{
	/**
	 * Gets WLAN config info
	 * 
	 * @param soapCredentials
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 */
	public GetInfo(ISoapCredentials soapCredentials, int interfaceIndex)
	{
		super(soapCredentials, interfaceIndex);
	}

	@Override
	public WLANConfigInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		
		WLANConfigInfo result = new WLANConfigInfo();

		result.setEnable(getBooleanByName("NewEnable", input));
		result.setStatus(getValueByName("NewStatus", input));
		result.setChannel(getIntByName("NewChannel", input));
		result.setSsid(getValueByName("NewSSID", input));
		result.setBeaconType(getValueByName("NewBeaconType", input));
		result.setMACAddressControlEnabled(getBooleanByName("NewMACAddressControlEnabled", input));
		result.setStandard(getValueByName("NewStandard", input));
		result.setBssid(getValueByName("NewBSSID", input));
        result.setBasicEncryptionModes(getValueByName("NewBasicEncryptionModes", input));
        result.setBasicAuthenticationMode(getValueByName("NewBasicAuthenticationMode", input));
        result.setSsidSpec(new StringSpec(
                getIntByName("NewMinCharsSSID", input),
                getIntByName("NewMaxCharsSSID", input),
                getValueByName("NewAllowedCharsSSID", input)));
        result.setPskSpec(new StringSpec(
                getIntByName("NewMinCharsPSK", input),
                getIntByName("NewMaxCharsPSK", input),
                getValueByName("NewAllowedCharsPSK", input)));

		return result;
	}

	@Override
	public String getSoapMethod()
	{
		return "GetInfo";
	}
}
