/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wanipconnection;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.PortMapping;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetSpecificPortMappingEntry extends WanIPConnectionSoapHelper<PortMapping>
{
	private String mRemoteHost = "";
	private int mExternalPort = 0;
	private String mProtocol = "";

	/**
	 * @throws IllegalArgumentException
	 * 		illegal value of externalPort 
	 */
	public GetSpecificPortMappingEntry(ISoapCredentials soapCredentials,
			String remoteHost, int externalPort, String protocol)
	{
		super(soapCredentials);
		
		UnsignedNumber.validateUi2(externalPort, "externalPort");

		mRemoteHost = remoteHost;
		mExternalPort = externalPort;
		mProtocol = protocol;
	}

    public String getRemoteHost()
    {
        return mRemoteHost;
    }

    public GetSpecificPortMappingEntry setRemoteHost(String remoteHost)
    {
        mRemoteHost = remoteHost;
        return this;
    }

    public int getExternalPort()
    {
        return mExternalPort;
    }

    public GetSpecificPortMappingEntry setExternalPort(int externalPort)
    {
        UnsignedNumber.validateUi2(externalPort, "externalPort");

        mExternalPort = externalPort;
        return this;
    }

    public String getProtocol()
    {
        return mProtocol;
    }

    public GetSpecificPortMappingEntry setProtocol(String protocol)
    {
        mProtocol = protocol;
        return this;
    }

    @Override
	public PortMapping getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

		PortMapping portMapping = new PortMapping();
		portMapping.setRemoteHost(mRemoteHost);
		portMapping.setExternalPort(mExternalPort);
		portMapping.setProtocol(mProtocol);
		portMapping.setInternalPort(getIntByName("NewInternalPort", input));
		portMapping.setInternalClient(getValueByName("NewInternalClient", input));
		portMapping.setEnabled(getBooleanByName("NewEnabled", input));
		portMapping.setPortMappingDescription(getValueByName("NewPortMappingDescription",
				input));
		portMapping.setLeaseDuration(getLongByName("NewLeaseDuration", input));

		return portMapping;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewRemoteHost>" + mRemoteHost + "</NewRemoteHost>" +
				"<NewExternalPort>" + Integer.toString(mExternalPort) + "</NewExternalPort>" +
				"<NewProtocol>" + mProtocol + "</NewProtocol>";
	}

	@Override
	public String getSoapMethod()
	{
		return "GetSpecificPortMappingEntry";
	}
}