/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wancommoninterfaceconfig;

import de.avm.android.tr064.soap.AbstractSoapHelper;
import de.avm.android.tr064.soap.ISoapCredentials;

public abstract class WanCommonIfaceConfigSoapHelper<RESULT> extends AbstractSoapHelper<RESULT>
{
	/*
	Service Id  urn:WANCIfConfig-com:serviceId:WANCommonInterfaceConfig1
	Service Type  urn:dslforum-org:service:WANCommonInterfaceConfig:1
	Control Url  /upnp/control/wancommonifconfig1
	Scpd Url  /wancommonifconfigSCPD.xml
	*/
	
	public WanCommonIfaceConfigSoapHelper(ISoapCredentials soapCredentials) 
	{
		super(soapCredentials);
	}

	public String getNamespace()
	{
		return "urn:dslforum-org:service:WANCommonInterfaceConfig:1";
	}

	public String getControlURL()
	{
		return "/upnp/control/wancommonifconfig1";
	}
}