/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.voip;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.soap.ISoapCredentials;

/* Soap implementation for the VoIPConf-Interface */
public class GetNumberOfClients extends VoIPConfSoapHelper<Integer>
{
	public GetNumberOfClients(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public Integer getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		return Integer.valueOf(getIntByName("NewX_AVM-DE_NumberOfClients",
				getSoapBody()));
	}

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_GetNumberOfClients";
	}
}