/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.remoteaccess;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.DDNSInfo;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetDDNSInfo extends RemoteAccessSoapHelper<DDNSInfo>
{
	public GetDDNSInfo(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public DDNSInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

		DDNSInfo result = new DDNSInfo();
		result.setEnabled(getBooleanByName("NewEnabled", input));
		result.setDomain(getValueByName("NewDomain", input));
		result.setMode(getValueByName("NewMode", input));
		result.setProviderName(getValueByName("NewProviderName", input));
		result.setServerIPv4(getValueByName("NewServerIPv4", input));
		result.setServerIPv6(getValueByName("NewServerIPv6", input));
		result.setStatusIPv4(getValueByName("NewStatusIPv4", input));
		result.setStatusIPv6(getValueByName("NewStatusIPv6", input));
		result.setUpdateUrl(getValueByName("NewUpdateURL", input));
		result.setUsername(getValueByName("NewUsername", input));

		return result;
	}

    @Override
    protected String filterSoapBeforeTrace(String body)
    {
        return replaceSecrets(body, new String[] { "NewUsername" });
    }

	@Override
	public String getSoapMethod()
	{
		return "GetDDNSInfo";
	}
}
