/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.myfritz;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.MyFritzService;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.soap.ISoapCredentials;

public class SetServiceByIndex extends MyFritzSoapHelper<Boolean>
{
	private MyFritzService mFritzService;

	/**
	 * @throws IllegalArgumentException
	 * 		illegal value of a member of service 
	 */
	public SetServiceByIndex(ISoapCredentials soapCredentials, MyFritzService service)
	{
		super(soapCredentials);
		UnsignedNumber.validateUi4(service.getIndex(), "Index");
		UnsignedNumber.validateUi2(service.getPort(), "Port");
		mFritzService = service;
	}

    public MyFritzService getService()
    {
        return mFritzService;
    }

    /**
     * @throws IllegalArgumentException
     * 		illegal value of a member of service
     */
    public SetServiceByIndex setIndex(MyFritzService service)
    {
        UnsignedNumber.validateUi4(service.getIndex(), "Index");
        UnsignedNumber.validateUi2(service.getPort(), "Port");
        mFritzService = service;
        return this;
    }

	@Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		// no out parameter, check for error response
		exceptOnFault(getSoapBody());
		return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewIndex>" + Long.toString(mFritzService.getIndex()) + "</NewIndex>" +
				"<NewEnabled>" + (mFritzService.isEnabled() ? 1 : 0) + "</NewEnabled>" +
				"<NewName>" + encodeEntities(mFritzService.getName()) + "</NewName>" +
				"<NewScheme>" + mFritzService.getScheme() + "</NewScheme>" +
				"<NewPort>" + Integer.toString(mFritzService.getPort()) + "</NewPort>" +
				"<NewURLPath>" + mFritzService.getURLPath() + "</NewURLPath>" +
				"<NewType>" + mFritzService.getType() + "</NewType>" +
				"<NewIPv4Address>" + mFritzService.getIPv4Addresses() + "</NewIPv4Address>" +
				"<NewIPv6Address>" + mFritzService.getIPv6Addresses() + "</NewIPv6Address>" +
				"<NewIPv6InterfaceID>" + mFritzService.getIPv6InterfaceIDs() + "</NewIPv6InterfaceID>" +
				"<NewMACAddress>" + mFritzService.getMACAddress() + "</NewMACAddress>" +
				"<NewHostName>" + mFritzService.getHostName() + "</NewHostName>";
	}

	@Override
	public String getSoapMethod()
	{
		return "SetServiceByIndex";
	}
}
