/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.hosts;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.soap.ISoapCredentials;

public class SetHostNameByMACAddress extends HostsSoapHelper<Boolean>
{
    private String mMac;
	private String mHostName;
	
	/**
	 * Sets host name
	 * 
	 * @param mac
	 * 		The MAC address to set host name for
	 * @param hostName
	 * 		The host name to set
	 */
	public SetHostNameByMACAddress(ISoapCredentials soapCredentials, String mac,
			String hostName)
	{
		super(soapCredentials);
		
		mMac = mac;
		mHostName = hostName;
	}

    public String getMac()
    {
        return mMac;
    }

    public SetHostNameByMACAddress setMac(String mac)
    {
        mMac = mac;
        return this;
    }

    public String getHostName()
    {
        return mHostName;
    }

    public SetHostNameByMACAddress setHostName(String hostName)
    {
        mHostName = hostName;
        return this;
    }

	@Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		// no out parameter, check for error response
		exceptOnFault(getSoapBody());
		return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewMACAddress>" + mMac + "</NewMACAddress>" +
				"<NewHostName>" + mHostName + "</NewHostName>";
	}

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_SetHostNameByMACAddress";
	}
}
