/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.sax;

import de.avm.android.tr064.Tr064Capabilities;

/*
 * SAX-Handler for FRITZ!Box VoIP1 description
 */
public class SAXVoIPConfScpdHandler extends SAXScpdHandler
{
	private static final int EXTENSIONS_ID_INDEX = 5;
	
	public boolean isCapabilitiyOfInterface(Tr064Capabilities cap)
	{
		return cap.has(Tr064Capabilities.Capability.VOIP_CONF) ||
				cap.has(Tr064Capabilities.Capability.VOIP_CONF_ID);
	}
	
	/**
	 * Instantiates a new sAX FRITZ!Box VoIP1 description handler.
	 */
	public SAXVoIPConfScpdHandler()
	{
		initActionsArray(new String[]
		{
			"GetInfoEx",
			"X_AVM-DE_GetNumberOfClients",
			"X_AVM-DE_GetClient",
			"X_AVM-DE_SetClient",
			"X_AVM-DE_DeleteClient",
			
			// extensions
			"X_AVM-DE_GetClient2"
		});
	}

	@Override
	public Tr064Capabilities getCapabilities()
	{
		boolean basic = true;
		for(int ii = 0; basic && (ii < EXTENSIONS_ID_INDEX); ii++)
			if (!mActions[ii].mIsAvailable)
				basic = false;

		if (basic)
		{
			Tr064Capabilities result = new Tr064Capabilities(
					Tr064Capabilities.Capability.VOIP_CONF);

			// extensions
			if (mActions[EXTENSIONS_ID_INDEX].mIsAvailable)
				result.add(Tr064Capabilities.Capability.VOIP_CONF_ID);
			
			return result;
		}
		
		return Tr064Capabilities.EMPTY; 
	}
}
