/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.net;

public interface IFingerprintPinningStore
{
	/**
	 * Gets certificate check option
	 * @return
	 * 		true to check if certificate's public key is trusted or
	 * 		false to check for certificates validity only
	 */
	boolean checkTrustCertificates();

	/**
	 * Gets known certificate's fingerprint
	 * @return fingerprint or null
	 */
	Fingerprint getCertificateFingerprint();
	
	/**
	 * Sets known certificate's fingerprint
	 * 
	 * Will be called by trust manager to populate fingerprint for new
	 * certificates with trusted public key. Don't do anything blocking
	 * within the implementation of this method!
	 * 
	 * @param fingerprint
	 */
	void setCertificateFingerprint(Fingerprint fingerprint);

	/**
	 * Gets fingerprint of trusted public key
	 * @return fingerprint or null
	 */
	Fingerprint getTrustedPublicKeyFingerprint();
}
