/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on VoIP as received from the Fritzbox
 */
public class VoIPInfoEx implements Parcelable
{
	/*
		NewVoIPPasswordMinChars  Out  Int  min. length of password 
		NewVoIPPasswordMaxChars  Out  Int  max. length of password 
		NewVoIPPasswordAllowedChars  Out  String  chars allowed in passwords 
	*/

    private StringSpec mVoIPPasswordSpec = null;

	public VoIPInfoEx()
	{
	}
	
	public VoIPInfoEx(Parcel in)
	{
        mVoIPPasswordSpec = in.readParcelable(null);
	}

    public StringSpec getVoIPPasswordSpec()
    {
        return mVoIPPasswordSpec;
    }

    public void setVoIPPasswordSpec(StringSpec spec)
    {
        mVoIPPasswordSpec = spec;
    }

    /**
     * @deprecated Use {@link #getVoIPPasswordSpec()} instead!
     */
	public int getPasswordMinChar()
	{
		return (mVoIPPasswordSpec == null) ?
                0 : mVoIPPasswordSpec.mMinChars;
	}

    /**
     * @deprecated Use {@link #getVoIPPasswordSpec()} instead!
     */
	public int getPasswordMaxChar()
	{
        return (mVoIPPasswordSpec == null) ?
                0 : mVoIPPasswordSpec.getMaxChars();
	}

    /**
     * @deprecated Use {@link #getVoIPPasswordSpec()} instead!
     */
	public String getPasswordAllowedChar()
	{
        return (mVoIPPasswordSpec == null) ?
                "" : mVoIPPasswordSpec.getAllowedChars();
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<VoIPInfoEx> CREATOR =
			new Parcelable.Creator<VoIPInfoEx>()
	{
		public VoIPInfoEx createFromParcel(Parcel in)
		{
			return new VoIPInfoEx(in);
		}

		public VoIPInfoEx[] newArray(int size)
		{
			return new VoIPInfoEx[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
        out.writeParcelable(mVoIPPasswordSpec, 0);
	}
}