/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

/*
 *  Represents information about a port mapping. As received from the FritzBox.
 */
public class PortMapping {
	private String mRemoteHost = "";
	private int mExternalPort = 0;
	private String mProtocol = "";
	private int mInternalPort = 0;
	private String mInternalClient = "";
	private boolean mEnabled = false;
	private String mPortMappingDescription = "";
	private long mLeaseDuration = 0L;

	public String getRemoteHost() {
		return mRemoteHost;
	}

	public void setRemoteHost(String remoteHost) {
		mRemoteHost = remoteHost;
	}

	public int getExternalPort() {
		return mExternalPort;
	}

	public void setExternalPort(int externalPort) {
		mExternalPort = externalPort;
	}

	public String getProtocol() {
		return mProtocol;
	}

	public void setProtocol(String protocol) {
		mProtocol = protocol;
	}

	public int getInternalPort() {
		return mInternalPort;
	}

	public void setInternalPort(int internalPort) {
		mInternalPort = internalPort;
	}

	public String getInternalClient() {
		return mInternalClient;
	}

	public void setInternalClient(String internalClient) {
		mInternalClient = internalClient;
	}

	public boolean isEnabled() {
		return mEnabled;
	}

	public void setEnabled(boolean enabled) {
		mEnabled = enabled;
	}

	public String getPortMappingDescription() {
		return mPortMappingDescription;
	}

	public void setPortMappingDescription(String portMappingDescription) {
		mPortMappingDescription = portMappingDescription;
	}

	public long getLeaseDuration() {
		return mLeaseDuration;
	}

	public void setLeaseDuration(long leaseDuration) {
		mLeaseDuration = leaseDuration;
	}
	
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		
		result.append(this.getClass().getName() + "Object {" + NEW_LINE);
		result.append(" Remote Host: " + mRemoteHost + NEW_LINE);
		result.append(" External Port: " + mExternalPort + NEW_LINE);
		result.append(" Protocol: " + mProtocol + NEW_LINE);
		result.append(" Internal Port: " + mInternalPort + NEW_LINE);
		result.append(" Internal Client: " + mInternalClient + NEW_LINE);
		result.append(" Enabled: " + mEnabled + NEW_LINE);
		result.append(" Description: " + mPortMappingDescription + NEW_LINE);
		result.append(" Lease Duration: " + mLeaseDuration + NEW_LINE);
		result.append("}");
		
		return result.toString();
	}
}
