/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.content.Context;

public interface IContactable
{
	/**
	 * Gets type name to display
	 * 
	 * @param context
	 * @return the string
	 */
	public String getTypeDisplay(Context context);
	
	/**
	 * Gets address to display
	 * 
	 * @return the string
	 */
	public String getAddressDisplay();
	
	/**
	 * Gets address to connect to (e.g. phone number)
	 * 
	 * @return the string
	 */
	public String getAddress();
}
