/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents dynamic DNS information, as received from the Fritzbox 
 */
public class DDNSInfo implements Parcelable
{
	/*
		NewEnabled  		out	Boolean
		NewDomain       	out	String
		NewMode				out	String
		NewProviderName		out String
		NewServerIPv4		out String
		NewServerIPv6		out String
		NewStatusIPv4		out String
		NewStatusIPv6		out String
		NewUpdateUrl		out String
		NewUsername     	out	String 
	*/
	
	private Boolean mEnabled = false;
	private String mDomain = "";
	private String mMode = "";
	private String mProviderName = "";
	private String mServerIPv4 = "";
	private String mServerIPv6 = "";
	private String mStatusIPv4 = "";
	private String mStatusIPv6 = "";
	private String mUpdateUrl = "";
	private String mUsername = "";
	
	public boolean isEnabled()
	{
		return mEnabled;
	}
	
	public void setEnabled(boolean enabled)
	{
		mEnabled = enabled;
	}

	public String getDomain()
	{
		return mDomain;
	}

	public void setDomain(String domain)
	{
		mDomain = domain;
	}

	public String getMode()
	{
		return mMode;
	}

	public void setMode(String mode)
	{
		mMode = mode;
	}

	public String getProviderName()
	{
		return mProviderName;
	}

	public void setProviderName(String providerName)
	{
		mProviderName = providerName;
	}

	public String getServerIPv4()
	{
		return mServerIPv4;
	}

	public void setServerIPv4(String serverIPv4)
	{
		mServerIPv4 = serverIPv4;
	}

	public String getServerIPv6()
	{
		return mServerIPv6;
	}

	public void setServerIPv6(String serverIPv6)
	{
		mServerIPv6 = serverIPv6;
	}

	public String getStatusIPv4()
	{
		return mStatusIPv4;
	}

	public void setStatusIPv4(String statusIPv4)
	{
		mStatusIPv4 = statusIPv4;
	}

	public String getStatusIPv6()
	{
		return mStatusIPv6;
	}

	public void setStatusIPv6(String statusIPv6)
	{
		mStatusIPv6 = statusIPv6;
	}

	public String getUpdateUrl()
	{
		return mUpdateUrl;
	}

	public void setUpdateUrl(String updateUrl)
	{
		mUpdateUrl = updateUrl;
	}

	public String getUsername()
	{
		return mUsername;
	}

	public void setUsername(String username)
	{
		mUsername = username;
	}

	public DDNSInfo(Parcel in)
	{
		mEnabled = in.readInt() != 0;
		mDomain = in.readString();
		mMode = in.readString();
		mProviderName = in.readString();
		mServerIPv4 = in.readString();
		mServerIPv6 = in.readString();
		mStatusIPv4 = in.readString();
		mStatusIPv6 = in.readString();
		mUpdateUrl = in.readString();
		mUsername = in.readString();
	}

	public DDNSInfo()
	{
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<DDNSInfo> CREATOR =
			new Parcelable.Creator<DDNSInfo>()
	{
		public DDNSInfo createFromParcel(Parcel in)
		{
			return new DDNSInfo(in);
		}

		public DDNSInfo[] newArray(int size)
		{
			return new DDNSInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt((mEnabled) ? 1 : 0);
		out.writeString(mDomain);
		out.writeString(mMode);
		out.writeString(mProviderName);
		out.writeString(mServerIPv4);
		out.writeString(mServerIPv6);
		out.writeString(mStatusIPv4);
		out.writeString(mStatusIPv6);
		out.writeString(mUpdateUrl);
		out.writeString(mUsername);
	}
}
