/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.views;

import android.content.Context;
import android.preference.Preference;
import android.util.AttributeSet;
import de.avm.fundamentals.R;
import de.avm.fundamentals.utils.PreferencesWifiInfo;

public class WifiInfoPreference extends Preference {

    public WifiInfoPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public WifiInfoPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setWifiInfo(PreferencesWifiInfo info){
        StringBuilder infoText = new StringBuilder();
        infoText.append(getContext().getString(R.string.device_name_label, info.mDeviceName)).append("\n");
        infoText.append(getContext().getString(R.string.fritzos_label, info.mFritzOs)).append("\n");
        infoText.append(getContext().getString(R.string.ssid_label, info.mSsid)).append("\n");
        infoText.append(getContext().getString(R.string.ip_label, info.mIp));
        setSummary(infoText.toString());
    }
}
