/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.views;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.preference.Preference;
import android.util.AttributeSet;
import de.avm.fundamentals.R;
import de.avm.fundamentals.activities.FeedbackActivity;

public class FeedbackPreference extends Preference implements Preference.OnPreferenceClickListener {

    private PackageInfo mPackageInfo;
    private Context mContext;

    public FeedbackPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        initPreference(context, attrs);
    }

    public FeedbackPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPreference(context, attrs);
    }

    private void initPreference(Context context, AttributeSet attrs) {
        mContext = context;
        setTitle(R.string.feedback);
        setOnPreferenceClickListener(this);
    }

    @Override
    public boolean onPreferenceClick(Preference preference) {
        mContext.startActivity(new Intent(mContext, FeedbackActivity.class));
        return false;
    }
}
