/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.utils;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

public class Toaster {
    private static final String LOG_TAG     = Toaster.class.getSimpleName();

    private static Toaster      mInstance;
    private static Context      mContext;

    public Toaster(final Context context) {
        mContext = context;
    }

    public static void instantiate(Context context) {
        if(mInstance == null) {
            mInstance = new Toaster(context);
        }
    }

    public static void toastLong(final String message) {
        Toast.makeText(mContext, message, Toast.LENGTH_LONG).show();
    }

    public static void toastLong(final int stringResId, final Object... params) {
        tryShowToast(stringResId, Toast.LENGTH_LONG, params);
    }

    public static void toastShort(final String message) {
        Toast.makeText(mContext, message, Toast.LENGTH_SHORT).show();
    }

    public static void toastShort(final int stringResId, final Object... params) {
        tryShowToast(stringResId, Toast.LENGTH_SHORT, params);
    }

    private static void tryShowToast(final int stringResId, final int toastLength, final Object... params) {
        try {
            Toast.makeText(mContext, mContext.getString(stringResId, params), toastLength).show();
        } catch (Exception e) {
            Log.e(LOG_TAG, ":: tryShowToast ::", e);
        }
    }
}
