/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.util;

import de.avm.android.fritzapp.R;
import de.avm.android.fritzapp.service.BoxService;
import de.avm.android.fritzapp.service.OutgoingCallActivity;
import de.avm.fundamentals.logger.FileLog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.DialogInterface.OnClickListener;
import android.text.TextUtils;
import android.view.View;
import android.widget.Toast;

/**
 * ClickListener der bei Click die uebergebene Nummer anruft.
 */
public class OnClickCallNumber implements View.OnClickListener
{
	private static final String TAG = "OnClickCallNumber";
	protected final String mNumber;
	
	public OnClickCallNumber(String number)
	{
		mNumber = number;
	}

	public void onClick(View v)
	{
		if (!TextUtils.isEmpty(mNumber))
		{
			try
			{
				Context context = v.getContext();
				if (PhoneNumberHelper.isInternalNumber(mNumber))
					context.startService(new Intent(context, BoxService.class)
							.putExtra(BoxService.EXTRA_COMMAND,
									BoxService.Command.CALL.ordinal())
							.putExtra(BoxService.EXTRA_NUMBER, mNumber)
							.putExtra(BoxService.EXTRA_FRITZ_APP, true));
				else
					context.startActivity(OutgoingCallActivity
							.createCallIntent(mNumber));
			}
			catch(Exception exp)
			{
				FileLog.e(TAG, "Cannot invoke phone call.", exp);
			}
		}
	}
	
	public void onLongClick(final View v)
	{
		if (!TextUtils.isEmpty(mNumber))
		{
			final Context context = v.getContext();
			String[] items = new String[]
			{
				context.getString(R.string.button_callnow),
				context.getString(R.string.copy_to_clipboard)
			};
			new AlertDialog.Builder(context)
				.setTitle(mNumber)
				.setCancelable(true)
				.setInverseBackgroundForced(true)
				.setItems(items, new OnClickListener()
				{
					public void onClick(DialogInterface dialog, int which)
					{
						switch (which)
						{
							case 0:
								OnClickCallNumber.this.onClick(v);
								break;
								
							case 1:
							{
                                Clipboard.create(context).setPlainText(mNumber);
								Toast.makeText(context, R.string.copied_to_clipboard,
										Toast.LENGTH_SHORT).show();
							}
						}
					}
				})
				.show();
		}		
	}
}
