/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.util;

import android.content.ClipData;
import android.content.Context;
import android.text.ClipboardManager;

public class Clipboard
{
    public static Clipboard create(Context context)
    {
        Object clipboardManager = context.getSystemService(Context.CLIPBOARD_SERVICE);

        if (android.content.ClipboardManager.class.isAssignableFrom(clipboardManager.getClass()))
            return new HoneycombClipboard((ClipboardManager)clipboardManager);

        return new Clipboard((ClipboardManager)clipboardManager);
    }

    public void setPlainText(CharSequence text)
    {
        mClipboardManager.setText(text);
    }

    protected Clipboard(ClipboardManager manager)
    {
        mClipboardManager = manager;
    }

    protected ClipboardManager mClipboardManager;

    private static class HoneycombClipboard extends Clipboard
    {
        protected HoneycombClipboard(ClipboardManager manager)
        {
            super(manager);
        }

        @Override
        public void setPlainText(CharSequence text)
        {
            ClipData clipData = ClipData.newPlainText("", text);
            ((android.content.ClipboardManager)mClipboardManager).setPrimaryClip(clipData);
        }
    }
}
