/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.service;

public interface IBoxService
{
	/**
	 * @return true if service has been started and is still running
	 */
	boolean isActive();
	
	/**
	 * Disconnect from box and reconnect if active
	 */
	void reconnect();
	
	/**
	 * Reconnect to SIP (e.g. to reflect new user/password)
	 */
	void reconnectSip();
	
	/**
	 * Disconnect and connect to another box
	 */
	void switchTo(String udn);
	
	/**
	 * Starts new search for boxes
	 * 
	 * @param additionalHosts
	 * 		known hosts to connect to directly
	 */
	void searchBoxes(String[] additionalHosts);
	
	/**
	 * Recently saved com error message
	 * 
	 * @return
	 */
	ComErrorMessage getLastComError();
	
	/**
	 * Removes last COM error
	 * 
	 * @param comError
	 * 		remove this
	 */
	void removeLastComError(ComErrorMessage comError);
	
	/**
	 * @return true if CLIR setting has to be inverted on next call
	 */
	boolean isOverrideClirOnce();
	
	/**
	 * Sets if CLIR setting has to be inverted on next call
	 * 
	 * @param on
	 * 		enable/disable
	 */
	void setOverrideClirOnce(boolean on);

    /**
     * A option affecting Notifications has been changed by user
     */
    void onNotificationOptionChanged();
}
