/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.gui;

import android.app.Activity;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import android.widget.PopupMenu;

import de.avm.android.fritzapp.R;

/**
 * Activity with overflow menu button. Inherit or use class Delegate.
 * The Layout has to have a overflow button with R.id.overflow_menu
 */
public class OverflowMenuActivity extends Activity
{
    public static class Delegate
    {
        public Delegate(Activity activity)
        {
            mActivity = activity;
        }

        public void onPostCreateActivity()
        {
            View view = mActivity.findViewById(R.id.overflow_menu);
            if ((view == null) || !ImageButton.class.isAssignableFrom(view.getClass()))
                throw new IllegalStateException("Layout of activity must contain an " +
                        "ImageButton with R.id.overflow_menu");
            mOverflowMenuButton = (ImageButton)view;
            mOverflowMenuButton.setVisibility(View.VISIBLE);
            mOverflowMenuButton.setOnClickListener(new View.OnClickListener()
            {
                public void onClick(View v)
                {
                    onOverflowMenu();
                }
            });
        }
        public void invalidateOptionsMenu()
        {
            mOverflowMenu = null;
        }

        private Activity mActivity;
        private ImageButton mOverflowMenuButton = null;
        private PopupMenu mOverflowMenu = null;

        private void onOverflowMenu()
        {
            if (mOverflowMenu == null)
            {
                PopupMenu popupMenu = new PopupMenu(mActivity, mOverflowMenuButton);
                if (mActivity.onCreateOptionsMenu(popupMenu.getMenu()))
                {
                    mOverflowMenu = popupMenu;
                    mOverflowMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener()
                    {
                        public boolean onMenuItemClick(MenuItem menuItem)
                        {
                            return mActivity.onOptionsItemSelected(menuItem);
                        }
                    });
                    mOverflowMenu.setOnDismissListener(new PopupMenu.OnDismissListener()
                    {
                        public void onDismiss(PopupMenu popupMenu)
                        {
                            mActivity.onOptionsMenuClosed(mOverflowMenu.getMenu());
                        }
                    });
                }
            }

            if ((mOverflowMenu != null) &&
                    mActivity.onPrepareOptionsMenu(mOverflowMenu.getMenu()))
            {
                mOverflowMenu.show();
            }
        }
    }

    private Delegate mDelegate = new Delegate(this);

    @Override
    protected void onPostCreate(Bundle savedInstanceState)
    {
        super.onPostCreate(savedInstanceState);
        mDelegate.onPostCreateActivity();
    }

    @Override
    public void invalidateOptionsMenu()
    {
        super.invalidateOptionsMenu();
        mDelegate.invalidateOptionsMenu();
    }
}
