/*
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.MyFritzService;

public class SetServiceByIndex extends MyFritzSoapHelper<Boolean> {
	private MyFritzService mFritzService;

	public SetServiceByIndex(ISoapCredentials soapCredentials,
			MyFritzService service) {
		super(soapCredentials);
		mFritzService = service;
	}

	@Override
	public Boolean getQualifiedResult() throws DataMisformatException,
			BaseException, IOException {
		String input = getSoapBody();

		// no out parameter, check for error response
		Matcher m = Pattern.compile("faultcode>(.*?)<\\/faultcode").matcher(
				input);
		if (m.find())
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter() {
		String params = "<NewIndex>" + mFritzService.getIndex() + "</NewIndex>" +
				"<NewEnabled>" + (mFritzService.isEnabled() ? 1 : 0) + "</NewEnabled>" +
				"<NewName>" + mFritzService.getName() + "</NewName>" +
				"<NewScheme>" + mFritzService.getScheme() + "</NewScheme>" +
				"<NewPort>" + mFritzService.getPort() + "</NewPort>" +
				"<NewURLPath>" + mFritzService.getURLPath() + "</NewURLPath>" +
				"<NewIPv4Address>" + mFritzService.getIPv4Addresses() + "</NewIPv4Address>" +
				"<NewIPv6Address>" + mFritzService.getIPv6Addresses() + "</NewIPv6Address>" +
				"<NewIPv6InterfaceID>" + mFritzService.getIPv6InterfaceIDs() + "</NewIPv6InterfaceID>" +
				"<NewMACAddress>" + mFritzService.getMACAddress() + "</NewMACAddress>" +
				"<NewHostName>" + mFritzService.getHostName() + "</NewHostName>";
		return params;
	}

	@Override
	public String getSoapMethod() {
		return "SetServiceByIndex";
	}
}
