/*
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.MyFritzService;
import de.avm.android.tr064.model.MyFritzService.IPv4ForwardingWarning;

public class GetServiceByIndex extends MyFritzSoapHelper<MyFritzService> {
	private MyFritzService mFritzService = new MyFritzService();

	public GetServiceByIndex(ISoapCredentials soapCredentials, int index) {
		super(soapCredentials);
		mFritzService.setIndex(index);
	}

	@Override
	public MyFritzService getQualifiedResult() throws DataMisformatException,
			BaseException, IOException {
		String input = getSoapBody();
		Matcher m = Pattern.compile("<NewEnabled>(.*?)<\\/NewEnabled>")
				.matcher(input);
		try {
			int enable = (m.find()) ? Integer.parseInt(m.group(1)) : -1;
			if (enable == 0)
				mFritzService.setEnabled(false);
			else if (enable == 1)
				mFritzService.setEnabled(true);
			else
				throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);
		} catch (NumberFormatException exp) {
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION, exp);
		}

		m = Pattern.compile("<NewName>(.*?)<\\/NewName>").matcher(
				input);
		if (m.find()) {
			mFritzService.setName(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewScheme>(.*?)<\\/NewScheme>").matcher(
				input);
		if (m.find()) {
			mFritzService.setScheme(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewPort>(.*?)<\\/NewPort>").matcher(input);
		if (m.find()) {
			try {
				mFritzService.setPort(Integer.parseInt(decodeEntities(m.group(1))));
			} catch (NumberFormatException exp) {
				throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION,
						exp);
			}
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewURLPath>(.*?)<\\/NewURLPath>").matcher(
				input);
		if (m.find()) {
			mFritzService.setURLPath(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewIPv4ForwardingWarning>(.*?)<\\/NewIPv4ForwardingWarning>")
				.matcher(input);
		try {
			int warning = (m.find()) ? Integer.parseInt(m.group(1)) : -1;
			if (warning == IPv4ForwardingWarning.UNKNOWN.getCodeIPv4ForwardingWarning())
				mFritzService.setIPv4ForwardingWarning(IPv4ForwardingWarning.UNKNOWN);
			else if (warning == IPv4ForwardingWarning.NOT_NECESSARY_OR_SUCCEEDED.getCodeIPv4ForwardingWarning())
				mFritzService.setIPv4ForwardingWarning(IPv4ForwardingWarning.NOT_NECESSARY_OR_SUCCEEDED);
			else if (warning == IPv4ForwardingWarning.FAILED.getCodeIPv4ForwardingWarning())
				mFritzService.setIPv4ForwardingWarning(IPv4ForwardingWarning.FAILED);
			else
				throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);
		} catch (NumberFormatException exp) {
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION, exp);
		}

		m = Pattern.compile("<NewIPv4Addresses>(.*?)<\\/NewIPv4Addresses>").matcher(
				input);
		if (m.find()) {
			mFritzService.setIPv4Addresses(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewIPv6Addresses>(.*?)<\\/NewIPv6Addresses>").matcher(
				input);
		if (m.find()) {
			mFritzService.setIPv6Addresses(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewIPv6InterfaceIDs>(.*?)<\\/NewIPv6InterfaceIDs>").matcher(
				input);
		if (m.find()) {
			mFritzService.setIPv6InterfaceIDs(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewMACAddress>(.*?)<\\/NewMACAddress>").matcher(
				input);
		if (m.find()) {
			mFritzService.setMACAddress(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewHostName>(.*?)<\\/NewHostName>").matcher(
				input);
		if (m.find()) {
			mFritzService.setHostName(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("<NewDynDnsLabel>(.*?)<\\/NewDynDnsLabel>").matcher(
				input);
		if (m.find()) {
			mFritzService.setDynDnsLabel(decodeEntities(m.group(1)));
		} else
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		m = Pattern.compile("NewStatus>(.*?)<\\/NewStatus")
				.matcher(input);
		if (m.find())
		{
			try
			{
				mFritzService.setStatus(Integer.parseInt(m.group(1)));
			}
			catch(NumberFormatException  exp)
			{
				throw new DataMisformatException("Invalid Response from DeviceInfo Service", exp);
			}
		}
		else throw new DataMisformatException("Invalid Response from DeviceInfo Service");

		return mFritzService;
	}

	@Override
	public String getSoapMethodParameter() {
		String params = "<NewIndex>" + mFritzService.getIndex() + "</NewIndex>";
		return params;
	}

	@Override
	public String getSoapMethod() {
		return "GetServiceByIndex";
	}
}
