/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information about a WLAN Device. As received from the Fritzbox 
 */
public class WLANInfo implements Parcelable
{
	/*
		NewAssociatedDeviceIndex  In  Int  Index in der Liste (0 <= index < Anzahl) 
		NewAssociatedDeviceMACAddress  Out  String  MAC-Adresse des Gerätes 
		NewAssociatedDeviceIPAddress  Out  String  IP-Adresse des Gerätes 
		NewAssociatedDeviceAuthState  Out  Bool  Gerät angemeldet 
		NewX_AVM-DE_Speed  Out  Int  Datenrate (0 ... 300) 
		NewX_AVM-DE_SignalStrength  Out  Int  Signalstärke (0 … 70)
	*/

	private String macAdress = "";
	private String ipAdress = "";
	private boolean AuthState = false;
	private int speed = 0;
	private int signalStrength = 0;
	private String mSsid = "";
	
	public WLANInfo()
	{
	}
	
	public WLANInfo(Parcel in)
	{
		macAdress = in.readString();
		ipAdress = in.readString();
		AuthState = in.readInt() != 0;
		speed = in.readInt();
		signalStrength = in.readInt();
		mSsid = in.readString();
	}

	public String getMacAdress() {
		return macAdress;
	}
	
	public void setMacAdress(String macAdress) {
		this.macAdress = macAdress;
	}
	
	public String getIpAdress() {
		return ipAdress;
	}
	
	public void setIpAdress(String ipAdress) {
		this.ipAdress = ipAdress;
	}
	
	public boolean isAuthState() {
		return AuthState;
	}
	
	public void setAuthState(boolean authState) {
		AuthState = authState;
	}
	
	public int getBandwidth() {
		return speed;
	}
	
	public void setBandwidth(int bandwidth) {
		this.speed = bandwidth;
	}
	
	public int getSignalStrength() {
		return signalStrength;
	}
	
	public void setSignalStrength(int signalStrength) {
		this.signalStrength = signalStrength;
	}
	
	public String getSsid()
	{
		return mSsid;
	}

	public void setSsid(String ssid)
	{
		mSsid = ssid;
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<WLANInfo> CREATOR =
			new Parcelable.Creator<WLANInfo>()
	{
		public WLANInfo createFromParcel(Parcel in)
		{
			return new WLANInfo(in);
		}

		public WLANInfo[] newArray(int size)
		{
			return new WLANInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeString(macAdress);
		out.writeString(ipAdress);
		out.writeInt((AuthState) ? 1 : 0);
		out.writeInt(speed);
		out.writeInt(signalStrength);
		out.writeString(mSsid);
	}
}