/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.exceptions;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class SslCertificateException extends CertificateException
{
	private static final long serialVersionUID = -3810837579425797540L;
	
	private X509Certificate[] mChain; 

	public SslCertificateException(X509Certificate[] chain, CertificateException cause)
	{
		super(cause.getMessage(), cause);
		mChain = chain;
	}
	
	public static X509Certificate[] getCertificateChain(Exception e)
	{
		for (Throwable cause = e; cause != null; cause = cause.getCause())
			if (SslCertificateException.class.isAssignableFrom(cause.getClass()))
				return ((SslCertificateException)cause).mChain;
		return null;
	}
}
