/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.sax;

import de.avm.android.tr064.Tr064Capabilities;

/*
 * SAX-Handler for FRITZ!Box TAM1 description
 */
public class SAXTamScpdHandler extends SAXScpdHandler
{
	public boolean isCapabilitiyOfInterface(Tr064Capabilities cap)
	{
		return cap.has(Tr064Capabilities.Capability.TAM);
	}
	
	/**
	 * Instantiates a new sAX FRITZ!Box TAM1 description handler.
	 */
	public SAXTamScpdHandler()
	{
		initActionsArray(new String[]
		{
			"GetInfo",
			"SetEnable",
		});
	}

	@Override
	public Tr064Capabilities getCapabilities()
	{
		for(ActionInfo action : mActions)
			if (!action.mIsAvailable) return Tr064Capabilities.EMPTY;
		return new Tr064Capabilities(
				Tr064Capabilities.Capability.TAM);
	}
}
