/*
 * Copyright (C) 2012 AVM GmbH <info@avm.de>
 * Copyright (C) 2009 The Sipdroid Open Source Project
 * 
 * This file is part of Sipdroid (http://www.sipdroid.org)
 * 
 * Sipdroid is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.avm.android.fritzapp.sipua.ui;

import de.avm.android.fritzapp.R;
import de.avm.android.fritzapp.sipua.ui.InstantAutoCompleteTextView;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.InputType;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import android.widget.EditText;

public class CallScreen extends Activity implements DialogInterface.OnClickListener
{
	public static final int FIRST_MENU_ID = Menu.FIRST;
//	public static final int HOLD_MENU_ITEM = FIRST_MENU_ID + 2;
	public static final int MUTE_MENU_ITEM = FIRST_MENU_ID + 3;
//	public static final int TRANSFER_MENU_ITEM = FIRST_MENU_ID + 7;

	private static EditText transferText;
	
	long mKeyguardDisabledTime = 0;
    KeyguardManager.KeyguardLock mKeyguardLock = null;
    boolean mKeyguardEnabled = true;

    @Override
	public void onCreate(Bundle savedInstanceState)
    {
		super.onCreate(savedInstanceState);

        // take precedence over key guard.
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED);
    }
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		boolean result = super.onCreateOptionsMenu(menu);

		MenuItem m;
//		m = menu.add(0, HOLD_MENU_ITEM, 0, R.string.menu_hold);
//		m.setIcon(android.R.drawable.stat_sys_phone_call_on_hold);
		m = menu.add(0, MUTE_MENU_ITEM, 0, R.string.menu_mute);
		m.setIcon(android.R.drawable.stat_notify_call_mute);
//		m = menu.add(0, TRANSFER_MENU_ITEM, 0, R.string.menu_transfer);
//		m.setIcon(android.R.drawable.ic_menu_call);
				
		return result;
	}

	public void onClick(DialogInterface dialog, int which)
	{
		if (which == DialogInterface.BUTTON_POSITIVE)
			Receiver.engine(this).transfer(transferText.getText().toString());
	}

	protected void transfer() {
		transferText = new InstantAutoCompleteTextView(Receiver.mContext,null);
		transferText.setInputType(InputType.TYPE_CLASS_TEXT |
					  InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS);

		new AlertDialog.Builder(this)
				.setTitle(Receiver.mContext.getString(R.string.transfer_title))
				.setView(transferText)
				.setPositiveButton(R.string.ok, this)
				.setNegativeButton(R.string.cancel, this)
				.setInverseBackgroundForced(true)
				.show();
	}

	void disableKeyguard()
	{
		if ((mKeyguardLock != null) && mKeyguardEnabled)
		{
			mKeyguardLock.disableKeyguard();
			mKeyguardEnabled = false;
			mKeyguardDisabledTime = SystemClock.elapsedRealtime();
		}
	}
	
	void reenableKeyguard()
	{
		if ((mKeyguardLock != null) && !mKeyguardEnabled)
		{
			if (SystemClock.elapsedRealtime() < mKeyguardDisabledTime + 500)
			{
				try { Thread.sleep(500); }
				catch (InterruptedException e) {}
			}
			mKeyguardLock.reenableKeyguard();
			mKeyguardEnabled = true;
		}
	}
	
	protected void updateDismissKeyguard(boolean dismiss)
	{
		if (mKeyguardLock == null)
		{
	        if (dismiss)
	            getWindow().addFlags(
	            		WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);
	        else
	            getWindow().clearFlags(
	            		WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);
		}
	}
	
	@Override
	public void onStart()
	{
		super.onStart();
    	if (!Sipdroid.release) Log.i("SipUA:","on start");
    	disableKeyguard();
	}
	
	@Override
	public void onResume()
	{
		super.onResume();
    	if (!Sipdroid.release) Log.i("SipUA:","on resume");
        disableKeyguard();
	}
	
	@Override
	public void onPause()
	{
		super.onPause();
    	if (!Sipdroid.release) Log.i("SipUA:","on pause");
    	reenableKeyguard();
	}

 	@Override
 	public void onStop()
 	{
 		super.onStop();
 	   	if (!Sipdroid.release) Log.i("SipUA:","on stop");
 		reenableKeyguard();
 	 }
}
