/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.service;

import de.avm.android.fritzapp.com.ConnectionProblem;
import de.avm.android.fritzapp.gui.TextDialog;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;

public class ComErrorMessage implements IComErrorMessage
{
	private long mTimeStamp = 0;
	private String mMessage;
	private int mIcon = TextDialog.DEFAULT_EDIT_ICON;
	
	public long getTimeStamp()
	{
		return mTimeStamp;
	}

	public String getMessage()
	{
		return mMessage;
	}

	public int getIconResId()
	{
		return mIcon;
	}
	
	public ComErrorMessage(Context context, ConnectionProblem problem)
	{
		mTimeStamp = System.currentTimeMillis();
		mMessage = problem.getDisplayMessage(context);
		if (problem.isError() &&
				(problem != ConnectionProblem.FRITZBOX_NOTR064) &&
				(problem != ConnectionProblem.SSL_ERROR) &&
				(problem != ConnectionProblem.CERTIFICATE_ERROR))
			mIcon = android.R.drawable.ic_dialog_alert;
	}

	public ComErrorMessage(String message)
	{
		mTimeStamp = System.currentTimeMillis();
		mMessage = message;
	}

	public ComErrorMessage(String message, int iconResId)
	{
		mTimeStamp = System.currentTimeMillis();
		mMessage = message;
		mIcon = iconResId;
	}

	public ComErrorMessage(Parcel in)
	{
		mTimeStamp = in.readLong();
		mMessage = in.readString();
		mIcon = in.readInt();
	}
	
	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<ComErrorMessage> CREATOR =
			new Parcelable.Creator<ComErrorMessage>()
	{
		public ComErrorMessage createFromParcel(Parcel in)
		{
			return new ComErrorMessage(in);
		}

		public ComErrorMessage[] newArray(int size)
		{
			return new ComErrorMessage[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeLong(mTimeStamp);
		out.writeString(mMessage);
		out.writeInt(mIcon);
	}
}
