/*--------------------------------------------------------------------------*\

    KASSERT.H      Version 1.0                                    2000 AVM

    This file contains the prototypes for assert() and info().
    Here for Windows - kernel mode driver level.

\*--------------------------------------------------------------------------*/
#ifndef _kassert_h_
#define _kassert_h_

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if !defined (NDEBUG)
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void _assert (int Expr, char *pExpr, char *pszFile, int Line);
extern void _info (int Expr, char *pExpr, char *pszFile, int Line);
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#define assert(expr)                _assert(expr, #expr, __FILE__, __LINE__)
#define info(expr)                  _info(expr, #expr, __FILE__, __LINE__)
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#else
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#define assert(expr)
#define info(expr)
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
