/*---------------------------------------------------------------------------*\

    KASSERT.C      Version 1.0                                     2000 AVM

    This file contains the source code for assert() and info().
    Here for Windows - kernel mode driver level.

\*---------------------------------------------------------------------------*/
#ifdef WDM
#include <wdm.h>
#else
#include <ntddk.h>
#endif

#include "kassert.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if !defined (NDEBUG)
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void _assert (int Expr, char *pExpr, char *pszFile, int Line) {
    if (!Expr) {
        DbgPrint ("assertion %s failed in %s at line %d\n", pExpr, pszFile, Line);
    }

    /*----- DbgBreakPoint(); -----*/
}

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void _info (int Expr, char *pExpr, char *pszFile, int Line) {
    if (!Expr) {
        DbgPrint ("info: %s failed in %s at line %d\n", pExpr, pszFile, Line);
    }
}
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
