/*--------------------------------------------------------------------------*\

    CWINKMDL.H      Version 1.0                                     2000 AVM

    This file contains the operating system specific CAPI function
    prototypes, here for Windows - kernel mode driver level.
    According to CAPI 2.0 spec part II, chapter 8.15.

\*--------------------------------------------------------------------------*/
#ifndef _winkmdl_h_
#define _winkmdl_h_

#include "capi20.h"
#include "ckmdldef.h"


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
CAPI_REGISTER_ERROR CAPI20_REGISTER (unsigned MsgBufSize,
                                     unsigned MaxB3Connection,
                                     unsigned MaxB3Blks,
                                     unsigned MaxSizeB3,
                                     void **hCapi);

MESSAGE_EXCHANGE_ERROR CAPI20_RELEASE           (void *hCapi);
MESSAGE_EXCHANGE_ERROR CAPI20_PUT_MESSAGE       (void *hCapi, unsigned char *Msg);
MESSAGE_EXCHANGE_ERROR CAPI20_GET_MESSAGE       (void *hCapi, unsigned char **ReturnMessage);
MESSAGE_EXCHANGE_ERROR CAPI20_GET_PROFILE       (unsigned Controller, CAPI_GET_PROFILE_STRUCT *profile);
MESSAGE_EXCHANGE_ERROR CAPI20_GET_VERSION       (unsigned Controller, capi_version_params *version);
MESSAGE_EXCHANGE_ERROR CAPI20_GET_MANUFACTURER  (unsigned Controller, ptr_capi_manufacturer_buf manubuf);
MESSAGE_EXCHANGE_ERROR CAPI20_GET_SERIAL_NUMBER (unsigned Controller, ptr_capi_serial_number_buf sernum);
unsigned               CAPI20_ISINSTALLED       (void);


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
