/*--------------------------------------------------------------------------*\

    CKMDLDEF.H      Version 1.0                                     2000 AVM

    This file contains the definitions for handling IoDeviceObjects for CAPI.
    Here for Windows - kernel mode driver level.

\*--------------------------------------------------------------------------*/
#ifndef _ckmdldef_h_
#define _ckmdldef_h_

#ifdef WDM
#   include <wdm.h>
#else
#   include <ntddk.h>
#endif

/*---------------------------------------------------------------------------*\
 * Name of CAPI device
\*---------------------------------------------------------------------------*/
#define CAPI_DEVICE_NAME                L"\\Device\\CAPI201"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#define FILE_DEVICE_CAPI20              0x8001

/*---------------------------------------------------------------------------*\
 * device control codes, user and kernel applications
\*---------------------------------------------------------------------------*/
#define CAPI20_CTL_BASE                 0x800
#define CAPI20_CTL_REGISTER             (CAPI20_CTL_BASE + 0x0001)
#define CAPI20_CTL_RELEASE              (CAPI20_CTL_BASE + 0x0002)
#define CAPI20_CTL_GET_MANUFACTURER     (CAPI20_CTL_BASE + 0x0005)
#define CAPI20_CTL_GET_VERSION          (CAPI20_CTL_BASE + 0x0006)
#define CAPI20_CTL_GET_SERIAL           (CAPI20_CTL_BASE + 0x0007)
#define CAPI20_CTL_GET_PROFILE          (CAPI20_CTL_BASE + 0x0008)

/*---------------------------------------------------------------------------*\
 * kernel applications only
\*---------------------------------------------------------------------------*/
#define CAPI20_CTL_PUT_MESSAGE          (CAPI20_CTL_BASE + 0x0003)
#define CAPI20_CTL_GET_MESSAGE          (CAPI20_CTL_BASE + 0x0004)

/*---------------------------------------------------------------------------*\
 * io controls
\*---------------------------------------------------------------------------*/
#define CAPI20_CTL_CODE(function, method)   CTL_CODE (FILE_DEVICE_CAPI20, function, method, FILE_ANY_ACCESS)

#define IOCTL_CAPI_REGISTER                 CAPI20_CTL_CODE (CAPI20_CTL_REGISTER, METHOD_BUFFERED)
#define IOCTL_CAPI_RELEASE                  CAPI20_CTL_CODE (CAPI20_CTL_RELEASE,  METHOD_BUFFERED)
#define IOCTL_CAPI_GET_MANUFACTURER         CAPI20_CTL_CODE (CAPI20_CTL_GET_MANUFACTURER, METHOD_BUFFERED)
#define IOCTL_CAPI_GET_VERSION              CAPI20_CTL_CODE (CAPI20_CTL_GET_VERSION,  METHOD_BUFFERED)
#define IOCTL_CAPI_GET_SERIAL               CAPI20_CTL_CODE (CAPI20_CTL_GET_SERIAL,   METHOD_BUFFERED)
#define IOCTL_CAPI_GET_PROFILE              CAPI20_CTL_CODE (CAPI20_CTL_GET_PROFILE,  METHOD_BUFFERED)
#define IOCTL_CAPI_PUT_MESSAGE              CAPI20_CTL_CODE (CAPI20_CTL_PUT_MESSAGE,  METHOD_BUFFERED)
#define IOCTL_CAPI_GET_MESSAGE              CAPI20_CTL_CODE (CAPI20_CTL_GET_MESSAGE,  METHOD_BUFFERED)

/*---------------------------------------------------------------------------*\
 * CAPI20 internal structures, used for Device IO-Control and
 * internal Device IO-Control
\*---------------------------------------------------------------------------*/
typedef UCHAR  CAPIBYTE;
typedef USHORT CAPIWORD;
typedef ULONG  CAPIDWORD;

#pragma pack (1)

typedef struct _capi_register_params {
    CAPIWORD MessageBufferSize;
    CAPIWORD maxLogicalConnections;
    CAPIWORD maxBDataBlocks;
    CAPIWORD maxBDataLen;
} capi_register_params;

typedef struct _capi_message_params {
    PVOID message;
    PVOID data;
} capi_message_params;

typedef struct _capi_version_params {
    CAPIWORD CAPIMajor;
    CAPIWORD CAPIMinor;
    CAPIWORD ManufacturerMajor;
    CAPIWORD ManufacturerMinor;
} capi_version_params;

typedef struct _CAPI_GET_PROFILE_STRUCT {
    CAPIWORD  NumControllers;
    CAPIWORD  NumBChannels;
    CAPIDWORD GlobalOptions;
    CAPIDWORD B1ProtocolSupport;
    CAPIDWORD B2ProtocolSupport;
    CAPIDWORD B3ProtocolSupport;
    CAPIBYTE  Reserved[24];
    CAPIBYTE  ManufacturerSpecific[20];
} CAPI_GET_PROFILE_STRUCT;

typedef unsigned char capi_serial_number_buf[8], *ptr_capi_serial_number_buf;
typedef unsigned char capi_manufacturer_buf[64], *ptr_capi_manufacturer_buf;

typedef struct _CapiMessage {
    CAPIWORD Length;
    CAPIWORD ApplId;
    CAPIBYTE Command;
    CAPIBYTE SubCommand;
    CAPIWORD Number;

    struct {
        CAPIDWORD NCCI;
        PVOID     Data;
        CAPIWORD  Length;
        CAPIWORD  Handle;
        CAPIWORD  Flags;
    } DataB3;
} CapiMessage;

#define CAPI_HEADER_SIZE    8

#pragma pack ()


/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif
