#ifdef __KERNEL__

#ifndef ___compat_h__
#define ___compat_h__

#include <linux/config.h>

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

/* Don't rely on config.h for these symbols... */

#ifndef CONFIG_ISDN_CAPI_MIDDLEWARE
# define CONFIG_ISDN_CAPI_MIDDLEWARE
#endif
#ifndef CONFIG_ISDN_CAPI_CAPIFS
# define CONFIG_ISDN_CAPI_CAPIFS
#endif
#ifndef CONFIG_ISDN_DRV_AVMB1_VERBOSE_REASON
# define CONFIG_ISDN_DRV_AVMB1_VERBOSE_REASON
#endif
#ifndef CONFIG_ISDN_DRV_AVMB1_B1PCIV4
# define CONFIG_ISDN_DRV_AVMB1_B1PCIV4
#endif

#ifndef KERNEL_VERSION
#define KERNEL_VERSION(x,y,z)		(((x)<<16)+((y)<<8)+(z))
#endif

#define COMPAT_NEED_UACCESS
#define GET_USER			get_user
#define PUT_USER			put_user
#define RWTYPE				long
#define LSTYPE				long long
#define RWARG				unsigned long
#define LSARG				long long

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#define __exit
#define __devinit
#define __devinitdata
#define	COMPAT_NEED_PCI_IDS
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
#define module_init(x)			int init_module(void) { return x(); }
#define module_exit(x)			void cleanup_module(void) { x(); }
#endif

#define	ISDN_MSNLEN			20	/* was in linux/isdn.h */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,18)
#define COMPAT_HAS_NEW_SYMTAB
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,31)
#define CLOSETYPE void
#define CLOSEVAL
#else
#define CLOSETYPE int
#define CLOSEVAL (0)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,37)
#define test_and_clear_bit		clear_bit
#define test_and_set_bit		set_bit
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,45)
#define MINOR_PART(f)			MINOR(f->f_inode->i_rdev)
#else
#define MINOR_PART(f)			MINOR(f->f_dentry->d_inode->i_rdev)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,81)
#define kstat_irqs( PAR )		kstat.interrupts[PAR]
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,89)
#define poll_wait(f,wq,w)		poll_wait((wq),(w))
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,91)
#define COMPAT_HAS_NEW_PCI
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,13)
#define get_pcibase(ps, nr)		ps->base_address[nr]
#else
#define get_pcibase(ps, nr)		ps->resource[nr].start
#endif
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#define COMPAT_HAS_2_2_PCI
#define	dev_kfree_skb_any(a)		dev_kfree_skb(a)
#define pci_resource_start_io(d,nr)	d->base_address[nr] & \
					  PCI_BASE_ADDRESS_IO_MASK
#define pci_resource_start_mem(d,nr)	d->base_address[nr] & \
					  PCI_BASE_ADDRESS_MEM_MASK
#define devfs_register_chrdev(m,n,f)	register_chrdev(m,n,f)
#define devfs_unregister_chrdev(m,n)	unregister_chrdev(m,n)
#define i_count_read(ic)		ic
#define i_count_inc(ic)			ic++
#else
#define COMPAT_HAS_NEW_WAITQ
#define BIG_PHONE_NUMBERS
#define pci_resource_start_io(d, nr)	pci_resource_start(d, nr)
#define pci_resource_start_mem(d, nr)	pci_resource_start(d, nr)
#define i_count_read(ic)		atomic_read(&ic)
#define i_count_inc(ic)			atomic_inc(&ic)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,118)
#define FILEOP_HAS_FLUSH
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,127)
#define schedule_timeout(a)		current->timeout = jiffies + (a); \
						schedule ();
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,12)
#define COMPAT_HAS_NEW_SETUP
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,14)
#define net_device			device
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)
#define set_current_state(sta)		(current->state = sta)
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,22)
#define COMPAT_HAS_ISA_IOREMAP
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#define COMPAT_HAS_SCHEDULE_TASK
#define	HAVE_DEVFS_FS
#define	COMPAT_HAS_FILEOP_OWNER
#define COMPAT_HAS_pci_find_subsys
#define COMPAT_HAS_kmem_cache
#define COMPAT_d_alloc_root_one_parameter
#define COMPAT_HAS_init_special_inode
#define COMPAT_has_fileops_in_inode
#define COMPAT_has_generic_read_dir
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,18)
#define COMPAT_HAVE_NEW_FILLDIR
#endif

#if !defined (__CAPIDRV_C__) && (LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18))
typedef struct wait_queue	wait_queue_t;
typedef struct wait_queue *	wait_queue_head_t;

#define DECLARE_WAITQUEUE(wait, current) \
					struct wait_queue wait={current,NULL}
#define DECLARE_WAIT_QUEUE_HEAD(wait)	wait_queue_head_t wait
#define init_waitqueue_head(x)		*(x)=NULL
#define init_waitqueue_entry(q,p)	((q)->task)=(p)
#endif

#ifdef COMPAT_NEED_PCI_IDS
#define PCI_DEVICE_ID_AVM_B1		0x0700
#define PCI_DEVICE_ID_AVM_C4		0x0800
#define PCI_DEVICE_ID_AVM_C2		0x1100
#define PCI_DEVICE_ID_AVM_T1		0x1200
#endif

#if !defined (__CAPIDRV_C__) && defined (COMPAT_HAS_2_2_PCI)
#include <linux/pci.h>
static inline int pci_enable_device(struct pci_dev *dev)
{
        return 0;
}

#define PCI_ANY_ID (~0)

static inline struct pci_dev * pci_find_subsys(unsigned int vendor, unsigned int device,
                                        unsigned int ss_vendor, unsigned int ss_device,
                                        struct pci_dev *from)
{
        unsigned short subsystem_vendor, subsystem_device;

        while ((from = pci_find_device(vendor, device, from))) {
                pci_read_config_word(from, PCI_SUBSYSTEM_VENDOR_ID, &subsystem_vendor);
                pci_read_config_word(from, PCI_SUBSYSTEM_ID, &subsystem_device);
                if ((ss_vendor == PCI_ANY_ID || subsystem_vendor == ss_vendor) &&
                    (ss_device == PCI_ANY_ID || subsystem_device == ss_device))
                        return from;
        }
        return NULL;
}
#endif
#endif /* __KERNEL__ */
#endif /* ___compat_h__ */

