#ifdef __KERNEL__

/* Compatibility for various Linux kernel versions 
 *
 * (Extracted from the old isdn_compat.h file)
 */

#ifndef ___compat_h__
#define ___compat_h__

#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#ifndef KERNEL_VERSION
#define KERNEL_VERSION(x,y,z)		(((x)<<16)+((y)<<8)+(z))
#endif

#define COMPAT_NEED_UACCESS
#define GET_USER			get_user
#define PUT_USER			put_user
#define RWTYPE				long
#define LSTYPE				long long
#define RWARG				unsigned long
#define LSARG				long long

#define	ISDN_MSNLEN			20	/* was in linux/isdn.h */

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,15)
#define SET_SKB_FREE(x)			( x->free = 1 )
#define idev_kfree_skb(a,b)		dev_kfree_skb(a,b)
#else
#define SET_SKB_FREE(x)
#define idev_kfree_skb(a,b)		dev_kfree_skb(a)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,18)
#define COMPAT_HAS_NEW_SYMTAB
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,31)
#define CLOSETYPE void
#define CLOSEVAL
#else
#define CLOSETYPE int
#define CLOSEVAL (0)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,37)
#define test_and_clear_bit		clear_bit
#define test_and_set_bit		set_bit
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,45)
#define MINOR_PART(f)			MINOR(f->f_inode->i_rdev)
#else
#define MINOR_PART(f)			MINOR(f->f_dentry->d_inode->i_rdev)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,81)
#define kstat_irqs( PAR )		kstat.interrupts[PAR]
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,89)
#define poll_wait(f,wq,w)		poll_wait((wq),(w))
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,1,91)
#define COMPAT_HAS_NEW_PCI
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,13)
#define get_pcibase(ps, nr)		ps->base_address[nr]
#else
#define get_pcibase(ps, nr)		ps->resource[nr].start
#endif
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#define COMPAT_HAS_2_2_PCI
#define idev_kfree_skb_any(a,b)		dev_kfree_skb(a)
#define pci_resource_start_io(d,nr)	d->base_address[nr] & \
					  PCI_BASE_ADDRESS_IO_MASK
#define pci_resource_start_mem(d,nr)	d->base_address[nr] & \
					  PCI_BASE_ADDRESS_MEM_MASK
#define devfs_register_chrdev(m,n,f)	register_chrdev(m,n,f)
#define devfs_unregister_chrdev(m,n)	unregister_chrdev(m,n)
#define i_count_read(ic)		ic
#define i_count_inc(ic)			ic++
#else
#define COMPAT_HAS_NEW_WAITQ
#define BIG_PHONE_NUMBERS
#define idev_kfree_skb_any(a,b)		dev_kfree_skb_any(a)
#define pci_resource_start_io(d, nr)	pci_resource_start(d, nr)
#define pci_resource_start_mem(d, nr)	pci_resource_start(d, nr)
#define i_count_read(ic)		atomic_read(&ic)
#define i_count_inc(ic)			atomic_inc(&ic)
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,118)
#define FILEOP_HAS_FLUSH
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,1,127)
#define schedule_timeout(a)		current->timeout = jiffies + (a); \
					  schedule ();
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,0)
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,12)
#define COMPAT_HAS_NEW_SETUP
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,14)
#define net_device			device
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,16)
#define set_current_state(sta)		(current->state = sta)
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,3,22)
#define COMPAT_HAS_ISA_IOREMAP
#endif
#endif /* __KERNEL__ */
#endif /* ___compat_h__ */

