/* 
 * main.c
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef EXPORT_SYMTAB
# define EXPORT_SYMTAB
#endif
 
#include <stdarg.h>
#include <asm/uaccess.h>
#include <linux/config.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/errno.h>
#include <linux/capi.h>
#include <linux/ctype.h>

#if defined (__fcpci__)
#include <linux/pci.h>
#elif defined (__fcpnp__)
#include <linux/isapnp.h>
#endif

#include "capilli.h"
#include "driver.h"
#include "tools.h"
#include "defs.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static char *	REVCONST = "$Revision: $";
char		REVISION[32];

#if defined (MODULE_LICENSE)
MODULE_LICENSE ("Proprietary");
#endif
#if defined (MODULE_DESCRIPTION)
MODULE_DESCRIPTION ("CAPI4Linux: Driver for " PRODUCT_LOGO);
#endif

#if defined (__fcpcmcia__)
EXPORT_SYMBOL (avm_a1pcmcia_addcard);
EXPORT_SYMBOL (avm_a1pcmcia_delcard);
#else
EXPORT_NO_SYMBOLS;
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#if defined (__fcpci__)
#define	PCI_DEVICE_ID_FRITZ1	0x0A00
#define	PCI_DEVICE_ID_FRITZ2	0x0E00

static struct pci_device_id fcpci_id_table[] __initdata = {
	{ PCI_VENDOR_ID_AVM, PCI_DEVICE_ID_FRITZ1, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0 },
	{ PCI_VENDOR_ID_AVM, PCI_DEVICE_ID_FRITZ2, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0 },
	{ /* Terminating entry */ }
} ;

MODULE_DEVICE_TABLE (pci, fcpci_id_table);
#elif defined (__fcpnp__)
static struct isapnp_device_id fcpnp_id_table[] __initdata = {
	{ ISAPNP_VENDOR('A', 'V', 'M'), ISAPNP_FUNCTION(0x0900), 
		ISAPNP_VENDOR('A', 'V', 'M'), ISAPNP_FUNCTION(0x0900), 0 },
	{ /* Terminating entry */ }
} ;

MODULE_DEVICE_TABLE (isapnp, fcpnp_id_table);
#endif
#else
#define	__exit
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifndef NDEBUG
static void base_address (void) {

	lprintf (KERN_INFO, "Base adress: 0x%08X\n", &base_address);
} /* base_address */
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if defined (__fcpci__) || (defined (__fcpnp__) && defined (CONFIG_ISAPNP))
static int auto_attach (void) {
	struct capicardparams args;

	lprintf (KERN_INFO, "Auto-attaching...\n");
	return add_card (&capi_interface, &args);
} /* auto_attach */
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void inc_use_count (void) { MOD_INC_USE_COUNT; }
void dec_use_count (void) { MOD_DEC_USE_COUNT; }

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static int __init fritz_init (void) {
	char * tmp;
	
#define	RETURN(x)	MOD_DEC_USE_COUNT; return (x);

#ifndef NDEBUG
	base_address ();
#endif
	if ((NULL != (tmp = strchr (REVCONST, ':'))) && isdigit (*(tmp + 2))) {
		strncpy (REVISION, tmp + 1, sizeof (REVISION));
		tmp = strchr (REVISION, '$');
		*tmp = 0;
	} else {
		strcpy (REVISION, REV_DEFAULT);
	}
	lprintf (KERN_INFO, "%s, revision %s\n", DRIVER_LOGO, REVISION);
        lprintf (KERN_INFO, "(%s built on %s at %s)\n", TARGET, __DATE__, __TIME__);
		
	/*-------------------------------------------------------------------*\
	 * 64 bit CAPI is not supported yet.
	\*-------------------------------------------------------------------*/
	if (sizeof (char *) > 4) {
		lprintf (KERN_ERR, "Cannot deal with 64 bit CAPI messages!\n");
		return -ENOSYS;
	}

	MOD_INC_USE_COUNT;		/* Protect attachment procedure */
	lprintf (KERN_INFO, "Loading...\n");
	if (!driver_init ()) {
		lprintf (KERN_INFO, "Error: Driver library not available.\n");
		lprintf (KERN_INFO, "Not loaded.\n");
		RETURN (-ENOSYS);
	}
	capi_driver = attach_capi_driver (&capi_interface);
	if (NULL == capi_driver) {
		lprintf (KERN_INFO, "Error: Could not attach the driver.\n");
		lprintf (KERN_INFO, "Not loaded.\n");
		driver_exit ();
		RETURN (-EIO);
	} 
#if defined (__fcpci__) || (defined (__fcpnp__) && defined (CONFIG_ISAPNP))
	if (0 != auto_attach ()) {
		lprintf (KERN_INFO, "Not loaded.\n");
		detach_capi_driver (&capi_interface);
		driver_exit ();
		RETURN (-EIO);
	}
#endif   
	libheap_init (MAX_LIB_HEAP_SIZE);
	lprintf (KERN_INFO, "Loaded.\n");
	RETURN (0);

#undef RETURN

} /* fritz_init */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static void __exit fritz_exit (void) {

	if (capi_controller != NULL) {
		lprintf (KERN_INFO, "Shutting down controller...\n");
		stop (capi_card);
		(*capi_driver->detach_ctr) (capi_controller);
	}
	lprintf (KERN_INFO, "Removing...\n");
	detach_capi_driver (&capi_interface);
	libheap_exit ();
	driver_exit ();
#ifndef NDEBUG
	if (hallocated() != 0) {
		lprintf (KERN_ERR, "%u bytes leaked.\n", hallocated());
	}
#endif
	lprintf (KERN_INFO, "Removed.\n");
} /* fritz_exit */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
module_init (fritz_init);
module_exit (fritz_exit);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/

