/* 
 * tools.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_tools_h__
#define __have_tools_h__

#include <asm/atomic.h>
#include <linux/types.h>
#include <stdarg.h>
#include "defs.h"

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
extern __inline__ int atomic_inc_and_test_greater_zero (volatile atomic_t *v)
{
        unsigned char c;

        __asm__ __volatile__(
                LOCK "incl %0; setg %1"
                :"=m" (v->counter), "=qm" (c)
                :"m" (v->counter) : "memory");
        return c; /* can be only 0 or 1 */
}
#endif

#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,4)
#define VSNPRINTF(s,n,f,a)	vsnprintf (s, n, f, a)
#define SNPRINTF(s,n,f,l...)	snprintf (s, n, f, ##l)
#else
#define VSNPRINTF(s,n,f,a)	vsprintf (s, f, a)
#define SNPRINTF(s,n,f,l...)	sprintf (s, f, ##l)
#endif

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifndef NDEBUG
# define assert(x)	(!(x)?message("%s(%d): assert (%s) failed\n", \
                                        __FILE__, __LINE__, #x):((void)0))
# define info(x)	(!(x)?message("%s(%d): info (%s) failed\n", \
					__FILE__, __LINE__, #x):((void)0))
# define log(f,x...)	message (f, ##x)

extern void message (const char * fmt, ...);
#else
# define assert(x)
# define info(x)
# define log(f,x...)
#endif

extern void lprintf  (const char * level, const char * fmt, ...);
extern void vlprintf (const char * level, const char * fmt, va_list args);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifndef NDEBUG
extern unsigned hallocated (void);
extern unsigned hallocator (void * mem);
extern int	hvalid (void * mem);
#endif

extern void *   hmalloc (unsigned size);
extern void *   hcalloc (unsigned size);

extern void     hfree (void * mem);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#ifdef NEED_MEM_STR_PROTOS

extern void * memcpy (void * d, const void * s, size_t n);
extern void * memmove (void * d, const void * s, size_t n);
extern void * memset (void * m, int x, size_t c);

extern int memcmp (const void * s1, const void * s2, size_t n);

extern char * strcpy (char * d, const char * s);
extern char * strcat (char * d, const char * s);
extern int strcmp (const char * s1, const char * s2);

extern size_t strlen (const char * s);

#endif
#endif
