/* 
 * driver.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_driver_h__
#define __have_driver_h__

#include <asm/semaphore.h>
#include <asm/atomic.h>
#include <linux/config.h>
#include <linux/skbuff.h>
#include <linux/capi.h>
#include <linux/usb.h>
#include "tables.h"
#include "queue.h"
#include "libdefs.h"
#include "tools.h"
#include "capilli.h"

#define	MAX_TRANSFER_SIZE		8192
#define	MAX_URB_COUNT			8

#pragma pack (1)

typedef struct {

	unsigned short product_id;
	unsigned short release_number;
	unsigned       self_powered;	
} device_info_t, * device_info_p;

#pragma pack ()

typedef void (* complete_func_p) (unsigned status, unsigned ref_data);
typedef unsigned (* get_next_tx_buffer_func_p) (char * pbuf);
typedef void (* event_handler_func_p) (unsigned eventmask);
typedef void (* new_rx_buffer_avail_func_p) (char * pbuf, unsigned length);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
typedef struct {

	char *					version;
	char *					string[8];
	struct capi_ctr *			kctrl;
} per_ctrl_t, * per_ctrl_p;

typedef struct {

	int					ctrl2;
	void *					ctxp;
	struct usb_device *			dev;
	struct capi_ctr *			ctr;
	get_next_tx_buffer_func_p		tx_get_next;
	event_handler_func_p			ev_handler;
	new_rx_buffer_avail_func_p		rx_avail;
	unsigned				max_buf_size;
	atomic_t				is_open;

	char *					tx_buffer;
	struct urb *				tx_urb;
	
	struct usb_endpoint_descriptor *	epread;
	struct usb_endpoint_descriptor *	epwrite;
	atomic_t				tx_pending;
	atomic_t				rx_pending;
	atomic_t				rx_count;
	char *					version;
	char *					string[8];
	unsigned				count;
	appltab_t *				appls;
	queue_t *				queue;
	unsigned				length;
	void				     (* reg_func) (void *, unsigned);
	void				     (* rel_func) (void *);
	void				     (* dwn_func) (void);
} dev_context_t, * dev_context_p;

typedef struct {

	dev_context_p				card;
	per_ctrl_p				ctrl;
} bundle_t, * bundle_p;

#define	GET_CARD(ctr)	(((bundle_p) (ctr)->driverdata)->card)
#define	GET_CTRL(ctr)	(((bundle_p) (ctr)->driverdata)->ctrl)

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#define	UNDEF_CONFIG			-1
#define	RESET_CONFIG			0
#define	LOADING_CONFIG			1
#define	RUNNING_CONFIG			1

extern int				card_config;

extern struct capi_driver_interface *	fdslusb_drv_interface;
extern struct capi_driver		fdslusb_capi_interface;
extern dev_context_p			fdslusb_capi_ctx;
extern lib_callback_p			fdslusb_capi_lib;
extern struct capi_ctr *		fdslusb_capi_ctrl[2];

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern dev_context_p get_context (void);
extern void disconnect_notify (dev_context_p pdc);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void enter_critical (void);
extern void leave_critical (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void lock (void);
extern void unlock (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int fdslusb_load_ware (struct capi_ctr * ctrl, capiloaddata * ware);
extern void fdslusb_reset_ctrl (struct capi_ctr * ctrl);
extern void fdslusb_remove_ctrl (struct capi_ctr * ctrl); 
extern void fdslusb_register_appl (struct capi_ctr * ctrl, __u16 appl, 
                                                  capi_register_params * args);
extern void fdslusb_release_appl (struct capi_ctr * ctrl, __u16 appl); 
extern void fdslusb_send_msg (struct capi_ctr * ctrl, struct sk_buff * skb); 
extern char * fdslusb_proc_info (struct capi_ctr * ctrl);
extern int fdslusb_ctr_info (char * page, char ** start, off_t ofs, int count, 
                                             int * eof, struct capi_ctr * ctr);
extern int fdslusb_drv_info (char * page, char ** start, off_t ofs, int count, 
                                          int * eof, struct capi_driver * drv); 
extern int fdslusb_add_card (struct capi_driver * drv, capicardparams *args); 

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void * data_by_id (unsigned appl_id);
extern struct capi_ctr * card_by_id (unsigned appl_id);
extern void * first_data (int * res);
extern void * next_data (int * res);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int appl_profile (unsigned appl_id, unsigned * blksize, 
						unsigned * blkcount);

extern int msg2stack (unsigned char * msg);
extern void msg2capi (unsigned char * msg);

extern void new_ncci (unsigned appl_id, __u32 ncci, unsigned winsize, 
							unsigned blksize);
extern void free_ncci (unsigned appl_id, __u32 ncci);

extern unsigned char * data_block (unsigned appl_id, __u32 ncci, 
							unsigned handle);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int make_thread (void);
extern void kill_thread (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern int init_urbs (dev_context_p pdc);
extern void unlink_urbs (dev_context_p pdc);
extern void free_urbs (dev_context_p pdc);

extern void start_closing_task (void (* func) (void *), void * data);
extern void init_closing_task (void);

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
extern void init (unsigned len, 
		  void  (* reg) (void *, unsigned),
		  void  (* rel) (void *),
		  void  (* dwn) (void));

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
#endif

