/* 
 * queue.h
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */

#ifndef __have_queue_h__
#define __have_queue_h__

#include <linux/skbuff.h>

typedef long long	tag_t;
typedef __u32		NCCI_t;

typedef struct __qitem {

	tag_t			key;
	struct sk_buff *	msg;
	struct __qitem *	succ;
	struct __qitem *	pred;
} qitem_t;

typedef struct __queue {

	qitem_t *		put;
	qitem_t *		get;
	qitem_t *		noconf;
} queue_t;

extern void queue_init (queue_t ** q);
extern void queue_exit (queue_t ** q);

extern int queue_put (queue_t * q, struct sk_buff * msg);
extern struct sk_buff * queue_peek (queue_t * q);
extern struct sk_buff * queue_get (queue_t * q);
extern void queue_drop (queue_t * q);

extern int queue_is_empty (queue_t * q);

extern void queue_park (queue_t * q, unsigned appl, NCCI_t ncci, unsigned hand);
extern void queue_conf (queue_t * q, unsigned appl, NCCI_t ncci, unsigned hand);

#endif

